/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.instance.service.persistent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.ejb.BPE_ObjectLocal;
import org.apache.ode.bpe.context.ejb.BPE_ObjectLocalHome;
import org.apache.ode.bpe.context.persistent.PersistentContextService;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.nonpersistent.PMIProcessTransientImpl;
import org.apache.ode.bpe.instance.persistent.PMIProcessPersistentImpl;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.instance.service.InstanceServiceException;
import org.apache.ode.bpe.instance.service.persistent.RegistrationUtil;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public class InstanceServicePersistentImpl
implements InstanceService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$instance$service$persistent$InstanceServicePersistentImpl == null ? (class$org$apache$ode$bpe$instance$service$persistent$InstanceServicePersistentImpl = InstanceServicePersistentImpl.class$("org.apache.ode.bpe.instance.service.persistent.InstanceServicePersistentImpl")) : class$org$apache$ode$bpe$instance$service$persistent$InstanceServicePersistentImpl).getName());
    private DefinitionService definitionService;
    private UUIDService uuidService;
    private ProcessService processService;
    private static final String PS_STATE_HASH = "process_state_hash";
    BPE_ObjectLocalHome blobHome;
    BPE_ObjectLocal blobProxy;
    private HashMap rootInstances = new HashMap();
    static /* synthetic */ Class class$org$apache$ode$bpe$instance$service$persistent$InstanceServicePersistentImpl;

    public void update(String rootkey, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        IPMIProcess inst = this.getInstance(rootkey, rootkey);
        IContextService cs = ec.getProcessService().getContextService(rootkey);
        if (inst.isMarkedForCleanUp()) {
            IContainer rootCont = cs.getRoot();
            rootCont.removeChild(rootkey);
            this.rootInstances.remove(rootkey);
        } else if (!inst.isStateless()) {
            HashMap instances = this.getInstances(rootkey);
            if (logger.isLoggable(Level.FINE)) {
                String s = "State in context to context: root:" + rootkey + " ";
                Iterator it = instances.values().iterator();
                while (it.hasNext()) {
                    PMIProcessPersistentImpl proc = (PMIProcessPersistentImpl)it.next();
                    proc.setProcessService(this);
                    s = s + "(" + proc.getKey() + ":" + proc.getState() + ") ";
                }
                logger.fine(s);
            }
            this.rootInstances.remove(rootkey);
            if (cs instanceof PersistentContextService) {
                this.flushPersistentContext((PersistentContextService)cs);
            }
        }
    }

    private void flushPersistentContext(PersistentContextService iService) throws BPException {
        iService.flush();
    }

    public Collection getRootInstances(String rootDefinitionKey) throws BPException {
        if (BPEProperties.IsRunningStandAlone()) {
            throw new UnsupportedOperationException();
        }
        LinkedList<IPMIProcess> returnCollection = new LinkedList<IPMIProcess>();
        RegistrationUtil ru = new RegistrationUtil();
        Collection rootProcessInstanceIDs = ru.getRegisteredRootInstanceIDs(rootDefinitionKey);
        Iterator iter = rootProcessInstanceIDs.iterator();
        while (iter.hasNext()) {
            String rootProcessInstanceID = (String)iter.next();
            if (rootProcessInstanceID == null) continue;
            IPMIProcess ipmiprocess = this.getRootInstance(rootProcessInstanceID);
            returnCollection.add(ipmiprocess);
        }
        return returnCollection;
    }

    public IPMIProcess getRootInstance(String rootkey) throws BPException {
        return this.getInstance(rootkey, rootkey);
    }

    public IPMIProcess getInstance(String rootkey, String key) throws BPException {
        HashMap instances = this.getInstances(rootkey);
        if (instances == null) {
            InstanceServiceException ise = new InstanceServiceException("IS_IMPL_PNF", new Object[]{key});
            ise.log(logger, Level.SEVERE);
            throw ise;
        }
        IPMIProcess p = (IPMIProcess)instances.get(key);
        if (p == null) {
            InstanceServiceException ise = new InstanceServiceException("IS_IMPL_PNF", new Object[]{key});
            ise.log(logger, Level.SEVERE);
            throw ise;
        }
        return p;
    }

    public IPMIProcess createRootInstance(IPMDRoot rootDefinition) throws BPException {
        logger.fine("Creating root instance for def:" + rootDefinition.getProcess().getKey().getValue());
        IPMIProcess inst = null;
        HashMap hm = new HashMap();
        if (rootDefinition.getIsStateless()) {
            inst = new PMIProcessTransientImpl(rootDefinition.getProcess().getKey().getValue(), this.definitionService, null);
        } else {
            inst = new PMIProcessPersistentImpl(null, rootDefinition.getProcess().getKey().getValue(), this);
            IPart hashPart = this.getStateHash(inst.getKey());
            hashPart.setObject(hm);
        }
        this.rootInstances.put(inst.getKey(), hm);
        this.addInstance(inst.getKey(), inst);
        return inst;
    }

    public DefinitionService getDefinitionService() {
        return this.definitionService;
    }

    public void init(DefinitionService ds, UUIDService us, ProcessService ps) {
        this.definitionService = ds;
        this.uuidService = us;
        this.processService = ps;
    }

    private HashMap getInstances(String rootkey) throws BPException {
        HashMap instances;
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine("Getting instances for root proc:" + rootkey);
        }
        if ((instances = (HashMap)this.rootInstances.get(rootkey)) == null) {
            IPart hashPart = this.getStateHash(rootkey);
            instances = (HashMap)hashPart.getObjectForReadWrite();
            Iterator it = instances.values().iterator();
            while (it.hasNext()) {
                PMIProcessPersistentImpl proc = (PMIProcessPersistentImpl)it.next();
                proc.setProcessService(this);
            }
            if (logger.isLoggable(Level.FINE)) {
                String s = "Getting state from context: root:" + rootkey + " ";
                it = instances.values().iterator();
                while (it.hasNext()) {
                    PMIProcessPersistentImpl proc = (PMIProcessPersistentImpl)it.next();
                    proc.setProcessService(this);
                    s = s + "(" + proc.getKey() + ":" + proc.getState() + ") ";
                }
                logger.fine(s);
            }
            this.rootInstances.put(rootkey, instances);
        }
        return instances;
    }

    public UUIDService getUUIDService() {
        return this.uuidService;
    }

    public void addInstance(String rootkey, IPMIProcess instance) throws BPException {
        HashMap instances = this.getInstances(rootkey);
        instances.put(instance.getKey(), instance);
    }

    public IPMIProcess remove(String rootkey, String key) throws BPException {
        HashMap instances = this.getInstances(rootkey);
        return (IPMIProcess)instances.remove(key);
    }

    public void init() {
        this.rootInstances.clear();
    }

    private IPart getStateHash(String rootkey) throws BPException {
        IPart hashPart;
        IContextService cs = this.processService.getContextService(rootkey);
        IContainer root = cs.getRoot();
        IContainer procroot = (IContainer)root.findChild(rootkey);
        if (procroot == null) {
            procroot = root.createContainer(rootkey);
        }
        if ((hashPart = (IPart)procroot.findChild(PS_STATE_HASH)) == null) {
            hashPart = procroot.createPart(PS_STATE_HASH);
        }
        return hashPart;
    }

    public IPMIProcess getInstanceForContext(String rootkey, String key) throws BPException {
        HashMap instances;
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine("Getting instances for root proc:" + rootkey);
        }
        if ((instances = (HashMap)this.rootInstances.get(rootkey)) == null) {
            return null;
        }
        IPMIProcess p = (IPMIProcess)instances.get(key);
        if (p == null) {
            return null;
        }
        return p;
    }

    private void setRootInstanceState(String rootKey, int state) throws BPException {
        IPart statePart = this.getStateHash(rootKey);
        HashMap instances = (HashMap)statePart.getObjectForReadWrite();
        IPMIProcess process = (IPMIProcess)instances.get(rootKey);
        process.setState(state);
    }

    public void pauseRootInstance(String rootKey) throws BPException {
        this.setRootInstanceState(rootKey, StateEnum.PAUSED.getIntValue());
    }

    public void resumeRootInstance(String rootKey) throws BPException {
        this.setRootInstanceState(rootKey, StateEnum.RUNNING.getIntValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

