/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction;

import org.apache.ode.bpe.context.IAccessControl;
import org.apache.ode.bpe.context.ICloneable;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.NullInvocationException;

public abstract class BaseInteraction
implements IInteraction,
IAccessControl,
ICloneable {
    private transient boolean m_isReadOnly = false;
    private transient boolean m_isDirty = false;

    public Object invoke(IInvocation iInvocation, Object iInput) throws InteractionException {
        if (iInvocation == null) {
            throw new NullInvocationException();
        }
        try {
            if (iInvocation.isMutator()) {
                this.setDirty(true);
            }
            Object resultObject = iInvocation.execute(this, iInput);
            return resultObject;
        }
        catch (InteractionException ie) {
            throw ie;
        }
        catch (Exception e) {
            InteractionException bpx = new InteractionException("NATIVE_EXCEPTION", new Object[]{"Exception"}, e);
            throw bpx;
        }
    }

    public boolean getReadOnly() {
        return this.m_isReadOnly;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.m_isReadOnly = isReadOnly;
    }

    protected boolean getDirty() {
        return this.m_isDirty;
    }

    protected void setDirty(boolean iIsDirty) {
        this.m_isDirty = iIsDirty;
    }

    public Object invoke(IInvocation iInvocation) throws InteractionException {
        return this.invoke(iInvocation, null);
    }

    public abstract /* synthetic */ void releaseResources() throws InteractionException;

    public abstract /* synthetic */ Object cloneObject() throws ContextServiceException;
}

