/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.operations;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.ode.bpe.interaction.query.NodeDescriptor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtil {
    public static Node findFirstChildTextNode(Node iNode) {
        Node nodeChild = iNode.getFirstChild();
        while (nodeChild != null) {
            if (nodeChild.getNodeType() != 3 && nodeChild.getNodeType() != 4) continue;
            return nodeChild;
        }
        return null;
    }

    public static String processNodeValue(Node node) {
        StringBuffer value = new StringBuffer();
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            value.append(node.getNodeValue());
            return value.toString();
        }
        for (Node nodeChild = node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            if (nodeChild.getNodeType() != 3 && nodeChild.getNodeType() != 4) continue;
            value.append(nodeChild.getNodeValue());
        }
        return value.toString();
    }

    public static void setTextValue(Node node, String iValue) {
        Node textNode = DOMUtil.findFirstChildTextNode(node);
        if (textNode == null) {
            textNode = node.getOwnerDocument().createTextNode(iValue);
            node.appendChild(textNode);
        } else {
            textNode.setNodeValue(iValue);
        }
    }

    public static void removeChildren(Node iNode) {
        Node node = iNode.getFirstChild();
        while (node != null) {
            iNode.removeChild(node);
            node = iNode.getFirstChild();
        }
    }

    public static void copyChildren(Node iSourceParent, Node iTargetParent) {
        NodeList nodeList = iSourceParent.getChildNodes();
        int length = nodeList.getLength();
        for (int count = 0; count < length; ++count) {
            Node node = nodeList.item(count);
            if (node == null) continue;
            DOMUtil.copyTree(iTargetParent, node);
        }
    }

    public static Node detachNode(Node iNode) {
        Node parent = iNode.getParentNode();
        parent.removeChild(iNode);
        return iNode;
    }

    public static void copyTree(Node iTargetParent, Node iTreeToCopy) {
        Document document = null;
        document = iTargetParent instanceof Document ? (Document)iTargetParent : iTargetParent.getOwnerDocument();
        Node copy = document.importNode(iTreeToCopy, true);
        iTargetParent.appendChild(copy);
    }

    public static void moveTree(Node iTreeToMove, Node iTargetParent) {
        Node movedNode = DOMUtil.detachNode(iTreeToMove);
        iTargetParent.appendChild(movedNode);
    }

    public static Node buildNodes(Node iParentNode, LinkedList iNodeDescriptorList) {
        Document document = null;
        document = iParentNode instanceof Document ? (Document)iParentNode : iParentNode.getOwnerDocument();
        Iterator iter = iNodeDescriptorList.iterator();
        Node currentParent = iParentNode;
        Element rootElem = document.getDocumentElement();
        while (iter.hasNext()) {
            NodeDescriptor nodeDescriptor = (NodeDescriptor)iter.next();
            Element newElement = null;
            if (nodeDescriptor.getName().equals("*")) {
                newElement = document.createElement("root");
            } else if (nodeDescriptor.getNamespaceURI() != null) {
                newElement = document.createElementNS(nodeDescriptor.getNamespaceURI(), nodeDescriptor.getName());
                if (rootElem == null) {
                    rootElem = newElement;
                }
                rootElem.setAttribute("xmlns:" + nodeDescriptor.getPrefix(), nodeDescriptor.getNamespaceURI());
            } else {
                newElement = document.createElementNS(null, nodeDescriptor.getName());
            }
            currentParent.appendChild(newElement);
            currentParent = newElement;
        }
        return currentParent;
    }
}

