/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.query;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.xml.utils.XMLChar;

public class NodeDescriptor
implements Serializable {
    static final long serialVersionUID = -7444717200424355396L;
    private String m_nodeDescriptorString;
    private String m_namespacePrefix;
    private String m_localName;
    private String m_URI;
    private boolean m_canBuild;

    public NodeDescriptor(HashMap iURIMap, String iNodeDescriptorString) {
        this.m_nodeDescriptorString = iNodeDescriptorString;
        this.analyze(iURIMap);
    }

    public String getName() {
        return this.m_nodeDescriptorString;
    }

    public String getLocalname() {
        return this.m_localName;
    }

    public String getPrefix() {
        return this.m_namespacePrefix;
    }

    public String getNamespaceURI() {
        return this.m_URI;
    }

    private void analyze(HashMap iURIMap) {
        int length = this.m_nodeDescriptorString.length();
        char currentChar = '\u0000';
        this.m_localName = this.m_nodeDescriptorString;
        this.m_namespacePrefix = "";
        this.m_canBuild = true;
        for (int currentIndex = 0; currentIndex < length; ++currentIndex) {
            currentChar = this.m_nodeDescriptorString.charAt(currentIndex);
            if (currentChar == ':') {
                this.m_namespacePrefix = this.m_nodeDescriptorString.substring(0, currentIndex);
                this.m_URI = (String)iURIMap.get(this.m_namespacePrefix);
                this.m_localName = this.m_nodeDescriptorString.substring(currentIndex + 1, length);
                continue;
            }
            if (XMLChar.isName((int)currentChar)) continue;
            this.m_canBuild = false;
            this.m_localName = null;
            this.m_URI = null;
            this.m_namespacePrefix = null;
            break;
        }
    }

    public String toString() {
        return this.m_nodeDescriptorString;
    }

    public void dump(OutputStream iOutputStream) {
        PrintStream printStream = new PrintStream(iOutputStream);
        printStream.println("Name = " + this.wrap(this.m_nodeDescriptorString));
        printStream.println("prefix = " + this.wrap(this.m_namespacePrefix));
        printStream.println("localName = " + this.wrap(this.m_localName));
        printStream.println("namespaceURI = " + this.wrap(this.m_URI));
        printStream.println("canBuild = " + this.m_canBuild);
    }

    private String wrap(String iString) {
        return "<" + iString + ">";
    }

    public boolean canBuild() {
        return this.m_canBuild;
    }
}

