/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.spiimpl.document;

import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteraction;
import org.apache.ode.bpe.client.spi.interaction.ISPIJaxenXPathQuery;
import org.apache.ode.bpe.client.spi.interaction.ISPIQuery;
import org.apache.ode.bpe.client.spi.interaction.ISPIXPathQuery;
import org.apache.ode.bpe.interaction.operations.CopyChildrenOperation;
import org.apache.ode.bpe.interaction.operations.CopyTreeOperation;
import org.apache.ode.bpe.interaction.operations.GetTextValueOperation;
import org.apache.ode.bpe.interaction.operations.IOperation;
import org.apache.ode.bpe.interaction.operations.PruneOperation;
import org.apache.ode.bpe.interaction.operations.SelectTreeOperation;
import org.apache.ode.bpe.interaction.operations.SetTextValueOperation;
import org.apache.ode.bpe.interaction.query.JaxenXPathSingleNodeQuery;
import org.apache.ode.bpe.interaction.spiimpl.CannedFormattableValue;
import org.apache.ode.bpe.interaction.spiimpl.document.DocumentFormattableValue;
import org.apache.ode.bpe.interaction.spiimpl.document.LazyDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class DocumentInteraction
implements ISPIInteraction {
    static final long serialVersionUID = 6173403782746777645L;
    private LazyDocument m_documentHolder = new LazyDocument();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    DocumentInteraction() {
    }

    DocumentInteraction(byte[] xmlbuffer) {
        this.m_documentHolder = new LazyDocument(xmlbuffer);
    }

    DocumentInteraction(Document document) {
        this.m_documentHolder = new LazyDocument(document);
    }

    public IFormattableValue getSimpleValue(ISPIQuery query) {
        GetTextValueOperation operation = new GetTextValueOperation();
        Object returnValue = this.executeOperation(operation, query, null);
        return this.createFormattableValue(returnValue);
    }

    protected Object executeOperation(IOperation operation, ISPIQuery query, Object argument) {
        try {
            JaxenXPathSingleNodeQuery jnq = new JaxenXPathSingleNodeQuery();
            if (query instanceof ISPIJaxenXPathQuery) {
                ISPIJaxenXPathQuery jq = (ISPIJaxenXPathQuery)query;
                jnq.setLocator(jq.getDOMXPath());
                jnq.setNamespaceMap(jq.getNamespaceMap());
                jnq.setXPathExpression(jq.getXPathExpressionAsString());
            } else if (query instanceof ISPIXPathQuery) {
                ISPIXPathQuery xq = (ISPIXPathQuery)query;
                jnq.setNamespaceMap(xq.getNamespaceMap());
                jnq.setXPathExpression(xq.getXPathExpressionAsString());
            }
            Object operationResult = operation.execute(this.m_documentHolder, jnq, argument, jnq.getXPathExpression());
            return operationResult;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setSimpleValue(ISPIQuery query, IFormattableValue iValue) {
        SetTextValueOperation operation = new SetTextValueOperation();
        String arg = (String)iValue.getValueAs(class$java$lang$String == null ? (class$java$lang$String = DocumentInteraction.class$("java.lang.String")) : class$java$lang$String);
        this.executeOperation(operation, query, arg);
        this.m_documentHolder.setDirty(true);
    }

    public IFormattableValue getComplexValue(ISPIQuery query) {
        SelectTreeOperation operation = new SelectTreeOperation();
        Object returnValue = this.executeOperation(operation, query, null);
        IFormattableValue value = this.createFormattableValue(returnValue);
        return value;
    }

    public void setComplexValue(ISPIQuery query, IFormattableValue iValue) {
        if (iValue.supportsGetValueAs(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DocumentInteraction.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node)) {
            CopyTreeOperation operation = new CopyTreeOperation();
            Node arg = (Node)iValue.getValueAs(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DocumentInteraction.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node);
            this.executeOperation(operation, query, arg);
            this.m_documentHolder.setDirty(true);
        } else {
            this.setSimpleValue(query, iValue);
        }
    }

    public void removeValue(ISPIQuery query) {
        PruneOperation operation = new PruneOperation();
        this.executeOperation(operation, query, null);
        this.m_documentHolder.setDirty(true);
    }

    public void copySubElements(ISPIQuery query, IFormattableValue source) {
        CopyChildrenOperation operation = new CopyChildrenOperation();
        Node arg = (Node)source.getValueAs(class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = DocumentInteraction.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node);
        this.executeOperation(operation, query, arg);
        this.m_documentHolder.setDirty(true);
    }

    public ISPIInteraction cloneSPIInteraction() {
        throw new UnsupportedOperationException();
    }

    public void releaseHeldResources() {
    }

    public boolean supportsSetSimpleValue(ISPIQuery query, ISPIInteraction iValue) {
        return true;
    }

    public boolean supportsGetComplexValue(ISPIQuery query) {
        return true;
    }

    public boolean supportsSetComplexValue(ISPIQuery query, ISPIInteraction iValue) {
        return true;
    }

    public boolean supportsRemoveValue(ISPIQuery query) {
        return true;
    }

    public boolean supportsCopySubElements(ISPIQuery query, IFormattableValue source) {
        return true;
    }

    public boolean supportsCloneSPIInteraction() {
        return false;
    }

    protected IFormattableValue createFormattableValue(Object value) {
        if (value instanceof Document) {
            return new DocumentFormattableValue((Document)value);
        }
        return new CannedFormattableValue(value);
    }

    public boolean supportsSetSimpleValue(ISPIQuery query, IFormattableValue iValue) {
        return true;
    }

    public boolean supportsSetComplexValue(ISPIQuery query, IFormattableValue iValue) {
        return true;
    }

    public IFormattableValue getValue() {
        return new DocumentFormattableValue(this.m_documentHolder);
    }

    public boolean supportsGetSimpleValue(ISPIQuery query) {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

