/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.pool;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.pool.ObjPool;
import org.apache.ode.bpe.pool.ObjPoolObject;
import org.apache.ode.bpe.pool.PoolException;

public abstract class SimpleObjPool
implements ObjPool {
    private List waiters = new ArrayList();
    private List checkedOutObjects = new ArrayList();
    protected Object sync = new Object();
    private boolean monitorCheckedOutObjects = true;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$pool$SimpleObjPool == null ? (class$org$apache$ode$bpe$pool$SimpleObjPool = SimpleObjPool.class$("org.apache.ode.bpe.pool.SimpleObjPool")) : class$org$apache$ode$bpe$pool$SimpleObjPool).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$pool$SimpleObjPool;

    protected abstract ObjPoolObject getNextPoolObject(Object var1, Object var2, Object var3) throws PoolException;

    protected abstract void checkinPoolObject(ObjPoolObject var1) throws PoolException;

    protected abstract void checkoutPoolObject(ObjPoolObject var1) throws PoolException;

    protected abstract ObjPoolObject createObjPoolObject(Object var1, Object var2, Object var3) throws PoolException;

    public SimpleObjPool() {
        this(true);
    }

    public SimpleObjPool(boolean monitorCheckedOutObjects) {
        this.monitorCheckedOutObjects = monitorCheckedOutObjects;
    }

    protected Object getSyncObject() {
        return this.sync;
    }

    public int getNumWaiters() {
        return this.waiters.size();
    }

    public int getObjectsInUse() {
        return this.checkedOutObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addToWaiters(Thread t) {
        List list = this.waiters;
        synchronized (list) {
            if (!this.waiters.contains(t)) {
                this.waiters.add(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Thread getNextWaiter() {
        List list = this.waiters;
        synchronized (list) {
            if (this.waiters.size() != 0) {
                return (Thread)this.waiters.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjPoolObject checkout(Object factory, Object auth, Object objSpec) throws PoolException {
        Thread thread = Thread.currentThread();
        ObjPoolObject obj = null;
        while (true) {
            Object object = this.sync;
            synchronized (object) {
                obj = this.getNextPoolObject(factory, auth, objSpec);
                if (obj != null) {
                    obj.beforeObjPoolObjectCheckout();
                    this.checkoutPoolObject(obj);
                    if (this.monitorCheckedOutObjects) {
                        this.checkedOutObjects.add(obj);
                    }
                    return obj;
                }
            }
            object = thread;
            synchronized (object) {
                this.addToWaiters(thread);
                try {
                    thread.wait();
                }
                catch (InterruptedException e) {
                    PoolException pe = new PoolException("NATIVE_EXECEPTION", new Object[]{"InterruptedException"}, e);
                    pe.log(logger, Level.SEVERE);
                    throw pe;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkin(ObjPoolObject opo) throws PoolException {
        opo.afterObjPoolObjectCheckin();
        Object object = this.sync;
        synchronized (object) {
            try {
                if (opo.isObjPoolObjectValid()) {
                    this.checkinPoolObject(opo);
                } else {
                    opo.deleteObjPoolObject();
                }
            }
            finally {
                Thread waiter;
                if (this.monitorCheckedOutObjects) {
                    this.checkedOutObjects.remove(opo);
                }
                if ((waiter = this.getNextWaiter()) != null) {
                    Thread thread = waiter;
                    synchronized (thread) {
                        waiter.notify();
                    }
                }
            }
        }
    }

    protected List getCheckedOutObjects() {
        return this.checkedOutObjects;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void reInitializeObjPool(Object var1, Object var2, Object var3) throws Exception;

    public abstract /* synthetic */ void init(Properties var1, Object var2, Object var3, Object var4) throws Exception;
}

