/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.scope.service;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScopePath
implements Serializable,
Cloneable {
    static final long serialVersionUID = 4835994200408519001L;
    public static final transient String DELIMITER = "/";
    private ArrayList scopePath;

    public ScopePath() {
        this.scopePath = new ArrayList();
    }

    private ScopePath(ArrayList scopePath) {
        this.scopePath = scopePath;
    }

    private ScopePath(List list) {
        this.scopePath = new ArrayList(list);
    }

    public ScopePath addScope(String scopeName, String scopeId) {
        this.scopePath.add(new ScopeNameId(scopeName, scopeId));
        return this;
    }

    public String getCurrentScope() {
        if (this.scopePath.size() < 1) {
            return "";
        }
        return ((ScopeNameId)this.scopePath.get(this.scopePath.size() - 1)).getName();
    }

    public ScopePath getEnclosingScopePath() {
        if (this.scopePath.isEmpty()) {
            return this;
        }
        return new ScopePath(((AbstractList)this.scopePath).subList(0, this.scopePath.size() - 1));
    }

    public String getScopeNamePath() {
        if (this.scopePath.isEmpty()) {
            return DELIMITER;
        }
        String path = "";
        Iterator it = ((AbstractList)this.scopePath).iterator();
        while (it.hasNext()) {
            ScopeNameId sni = (ScopeNameId)it.next();
            path = path + DELIMITER.concat(sni.getName());
        }
        return path;
    }

    public String applyPathIdsToPath(String path) {
        if (!path.startsWith(DELIMITER)) {
            return path;
        }
        String newPath = "";
        String[] pathArray = path.split(DELIMITER);
        for (int i = 1; i < pathArray.length; ++i) {
            if (i <= this.scopePath.size() && pathArray[i].equals(((ScopeNameId)this.scopePath.get(i - 1)).getName())) {
                newPath = newPath + DELIMITER.concat(((ScopeNameId)this.scopePath.get(i - 1)).getNameId());
                continue;
            }
            for (int j = i; j < pathArray.length; ++j) {
                newPath = newPath + DELIMITER.concat(pathArray[j]);
            }
            break;
        }
        return newPath;
    }

    public String toString() {
        if (this.scopePath.isEmpty()) {
            return DELIMITER;
        }
        String path = "";
        Iterator it = ((AbstractList)this.scopePath).iterator();
        while (it.hasNext()) {
            ScopeNameId sni = (ScopeNameId)it.next();
            path = path + DELIMITER.concat(sni.getNameId());
        }
        return path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ScopePath) {
            return obj.toString().equals(this.toString());
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return new ScopePath((ArrayList)this.scopePath.clone());
    }

    public static void main(String[] args) {
        ScopePath sp = new ScopePath();
        sp.addScope("a", "1");
        sp.addScope("b", "1");
        sp.addScope("c", "1");
        sp.addScope("d", "1");
        System.out.println(sp);
        System.out.println(sp.getCurrentScope());
        System.out.println(sp.getEnclosingScopePath());
        ScopePath sp2 = new ScopePath();
        sp2.addScope("a", "1");
        sp2.addScope("b", "1");
        sp2.addScope("c", "1");
        sp2.addScope("d", "1");
        System.out.println(sp.equals(sp2));
        System.out.println(sp2.applyPathIdsToPath("/container/part"));
        System.out.println(sp2.applyPathIdsToPath("/a/container/part"));
        System.out.println(sp2.applyPathIdsToPath("/a/b/c/container/part"));
        System.out.println(sp2.applyPathIdsToPath("/c/d/container/part"));
        System.out.println(sp.getScopeNamePath());
        ScopePath sp3 = new ScopePath();
        sp3.addScope("scope_0", "12345");
        System.out.println(sp3.applyPathIdsToPath("/scope_0/request/message"));
        System.out.println(sp3.applyPathIdsToPath("junk"));
        ScopePath sp4 = new ScopePath();
        sp4.addScope("a", "1");
        System.out.println(sp4.getEnclosingScopePath());
    }

    private class ScopeNameId
    implements Serializable {
        static final long serialVersionUID = -5709053091263193526L;
        private String name;
        private String id;

        public ScopeNameId(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getNameId() {
            return this.name.concat(this.id);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

