/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.util;

import java.util.Enumeration;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LoggerInformation {
    public static void getInfo() {
        LogManager manager = LogManager.getLogManager();
        Enumeration<String> names = manager.getLoggerNames();
        System.out.println("***Begin Logger Information");
        while (names.hasMoreElements()) {
            String loggername = names.nextElement();
            Logger logger = manager.getLogger(loggername);
            System.out.println("-----------------------");
            System.out.println("Logger name: >" + logger.getName() + "<");
            System.out.println("Logger level: " + logger.getLevel());
            if (logger.getFilter() != null) {
                System.out.println("Using a filter");
            } else {
                System.out.println("No filter used");
            }
            Handler[] h = logger.getHandlers();
            if (h.length == 0) {
                System.out.println("No handlers defined");
            }
            for (int i = 0; i < h.length; ++i) {
                if (i == 0) {
                    System.out.println("Handlers:");
                }
                Formatter f = h[i].getFormatter();
                System.out.println(h[i].getClass().getName());
                System.out.println("  using formatter: " + f.getClass().getName());
                System.out.println("  using level: " + h[i].getLevel());
                if (h[i].getFilter() != null) {
                    System.out.println("  using a filter");
                    continue;
                }
                System.out.println("  no filter");
            }
            Logger parent = logger.getParent();
            if (parent != null) {
                System.out.println("Parent: >" + parent.getName() + "<");
                continue;
            }
            System.out.println("No parent");
        }
        System.out.println("*** End Logger Information");
    }

    public static void tryLevels(Logger logger) {
        logger.severe("severe message");
        logger.warning("warning message");
        logger.info("info message");
        logger.config("config message");
        logger.fine("fine message");
        logger.finer("finer message");
        logger.finest("finest message");
    }
}

