/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.uuid.connector;

import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import org.apache.ode.bpe.pool.MinMaxObjPool;
import org.apache.ode.bpe.pool.ObjPoolObject;
import org.apache.ode.bpe.pool.PoolException;
import org.apache.ode.bpe.uuid.connector.UUIDConnectionSpec;
import org.apache.ode.bpe.uuid.connector.UUIDManagedConnection;
import org.apache.ode.bpe.uuid.connector.UUIDManagedConnectionFactory;
import org.apache.ode.bpe.uuid.connector.UUIDResourceException;

public class UUIDConnectionManager
extends MinMaxObjPool
implements ConnectionManager,
ConnectionEventListener {
    static final long serialVersionUID = -4273846573655733548L;
    private UUIDManagedConnectionFactory m_factory;
    private Subject m_auth;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$uuid$connector$UUIDConnectionManager == null ? (class$org$apache$ode$bpe$uuid$connector$UUIDConnectionManager = UUIDConnectionManager.class$("org.apache.ode.bpe.uuid.connector.UUIDConnectionManager")) : class$org$apache$ode$bpe$uuid$connector$UUIDConnectionManager).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$uuid$connector$UUIDConnectionManager;

    public UUIDConnectionManager(UUIDManagedConnectionFactory factory) throws PoolException {
        super(new HashSet(), false);
        this.m_factory = factory;
        Properties p = new Properties();
        this.init(p, factory, this.m_auth, new UUIDConnectionSpec());
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo info) throws ResourceException {
        ManagedConnection mc;
        if (managedConnectionFactory != this.m_factory) {
            throw new UUIDResourceException(logger, "UUID_MANAGED_FACTORY", null);
        }
        try {
            this.addSupportedType(info);
            mc = (ManagedConnection)this.checkout(managedConnectionFactory, this.m_auth, info);
        }
        catch (PoolException e) {
            throw new UUIDResourceException(logger, "UUID_POOL_EXCEPTION", null, e);
        }
        return mc.getConnection(null, info);
    }

    protected ObjPoolObject getUserIdentifiedObject(Object factory, Object auth, Object objSpec) throws PoolException {
        ManagedConnection ret = null;
        this.validateArgs(factory, auth, objSpec);
        try {
            ret = ((UUIDManagedConnectionFactory)factory).matchManagedConnections((HashSet)this.pool, (Subject)auth, (ConnectionRequestInfo)objSpec);
            if (ret != null) {
                if (!(ret instanceof ObjPoolObject) || !(ret instanceof UUIDManagedConnection)) {
                    PoolException pe = new PoolException("UUID_UNKOWN_OBJECT", null);
                    pe.log(logger, Level.SEVERE);
                    throw pe;
                }
                ((UUIDManagedConnection)ret).addConnectionEventListener(this);
            }
        }
        catch (ResourceException e) {
            PoolException pe = new PoolException("UUID_RESOURCE_EXCEPTION", null, e);
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        return (ObjPoolObject)ret;
    }

    protected void checkinPoolObject(ObjPoolObject o) throws PoolException {
        this.pool.add(o);
    }

    protected void checkoutPoolObject(ObjPoolObject o) throws PoolException {
        this.pool.remove(o);
    }

    protected ObjPoolObject createObjPoolObject(Object factory, Object auth, Object objectSpec) throws PoolException {
        ManagedConnection ret = null;
        this.validateArgs(factory, auth, objectSpec);
        try {
            ret = ((UUIDManagedConnectionFactory)factory).createManagedConnection((Subject)auth, (ConnectionRequestInfo)objectSpec);
        }
        catch (ResourceException e) {
            PoolException pe = new PoolException("UUID_RESOURCE_EXCEPTION", null, e);
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        return (ObjPoolObject)ret;
    }

    public void connectionClosed(ConnectionEvent arg0) {
        ManagedConnection mc = (ManagedConnection)arg0.getSource();
        mc.removeConnectionEventListener((ConnectionEventListener)this);
        try {
            this.checkin((ObjPoolObject)mc);
        }
        catch (PoolException poolException) {
            // empty catch block
        }
    }

    public void localTransactionStarted(ConnectionEvent arg0) {
    }

    public void localTransactionCommitted(ConnectionEvent arg0) {
    }

    public void localTransactionRolledback(ConnectionEvent arg0) {
    }

    public void connectionErrorOccurred(ConnectionEvent arg0) {
    }

    private void validateArgs(Object factory, Object auth, Object objectSpec) throws PoolException {
        if (factory != null && !(factory instanceof UUIDManagedConnectionFactory)) {
            PoolException pe = new PoolException("UUID_CAST_EXCEPTION", new Object[]{"pool factory", "UUIDManagedConnectionFactory"});
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        if (auth != null && !(auth instanceof Subject)) {
            PoolException pe = new PoolException("UUID_CAST_EXCEPTION", new Object[]{"pool auth", "Subject"});
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
        if (objectSpec != null && !(objectSpec instanceof ConnectionRequestInfo)) {
            PoolException pe = new PoolException("UUID_CAST_EXCEPTION", new Object[]{"pool objectSpec", "ConnectionRequestInfo"});
            pe.log(logger, Level.SEVERE);
            throw pe;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

