/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe;

import com.ibm.wsdl.extensions.PopulatedExtensionRegistry;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jbi.management.DeploymentException;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.deployment.bpel.BPELDefinitionKey;
import org.apache.ode.bpe.wsdl.extensions.BPEAction;
import org.apache.ode.bpe.wsdl.extensions.BPEActionSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEFault;
import org.apache.ode.bpe.wsdl.extensions.BPEFaultSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEInput;
import org.apache.ode.bpe.wsdl.extensions.BPEInputSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPELProperty;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertyAlias;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertyAliasSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPELPropertySerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEOutput;
import org.apache.ode.bpe.wsdl.extensions.BPEOutputSerializer;
import org.apache.ode.bpe.wsdl.extensions.BPEVariableMap;
import org.apache.ode.bpe.wsdl.extensions.BPEVariableMapSerializer;
import org.apache.ode.bpe.wsdl.extensions.ExtentionConstants;
import org.apache.servicemix.bpe.BPEComponent;
import org.apache.servicemix.bpe.BPEEndpoint;
import org.apache.servicemix.bpe.BPEServiceUnit;
import org.apache.servicemix.bpe.util.FileSystemJarInputStream;
import org.apache.servicemix.common.AbstractDeployer;
import org.apache.servicemix.common.ServiceMixComponent;
import org.apache.servicemix.common.ServiceUnit;
import org.apache.servicemix.common.tools.wsdl.WSDLFlattener;
import org.w3c.dom.Document;

public class BPEDeployer
extends AbstractDeployer {
    protected FilenameFilter filter = new BpelFilter();

    public BPEDeployer(BPEComponent component) {
        super((ServiceMixComponent)component);
    }

    public boolean canDeploy(String serviceUnitName, String serviceUnitRootPath) {
        File[] bpels = new File(serviceUnitRootPath).listFiles(this.filter);
        return bpels != null && bpels.length == 1;
    }

    public ServiceUnit deploy(String serviceUnitName, String serviceUnitRootPath) throws DeploymentException {
        try {
            EventDirector ed = ((BPEComponent)this.component).getEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            Collection defKeys = deployer.loadDefinition((InputStream)new FileSystemJarInputStream(new File(serviceUnitRootPath)), false);
            BPEServiceUnit su = new BPEServiceUnit();
            su.setComponent(this.component);
            su.setName(serviceUnitName);
            su.setRootPath(serviceUnitRootPath);
            su.setDefinitionKeys(defKeys);
            Definition rootDef = this.loadMainWsdl(serviceUnitRootPath);
            this.checkDefinition(rootDef, true);
            su.setDefinition(rootDef);
            WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
            WSDLFlattener flattener = new WSDLFlattener(rootDef);
            for (Service svc : rootDef.getServices().values()) {
                for (Port pt : svc.getPorts().values()) {
                    BPEEndpoint ep = new BPEEndpoint();
                    ep.setServiceUnit(su);
                    ep.setInterfaceName(pt.getBinding().getPortType().getQName());
                    ep.setService(svc.getQName());
                    ep.setEndpoint(pt.getName());
                    Definition def = flattener.getDefinition(ep.getInterfaceName());
                    Document desc = writer.getDocument(def);
                    ep.setDefinition(def);
                    ep.setDescription(desc);
                    this.validate(ep);
                    su.addEndpoint(ep);
                }
            }
            return su;
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    public void undeploy(ServiceUnit su) throws DeploymentException {
        try {
            BPEServiceUnit bpeSU = (BPEServiceUnit)su;
            EventDirector ed = ((BPEComponent)this.component).getEventDirector();
            IDeployer deployer = ed.getDeployer(DeployTypeEnum.BPEL);
            Iterator i = bpeSU.getDefinitionKeys().iterator();
            while (i.hasNext()) {
                deployer.removeDefinition(((BPELDefinitionKey)i.next()).getKey());
            }
            su.shutDown();
        }
        catch (DeploymentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected void checkDefinition(Definition rootDef, boolean main) throws DeploymentException {
        Collection msgs = rootDef.getMessages().values();
        for (Message msg : msgs) {
            if (msg.isUndefined()) {
                throw this.failure("deploy", "WSDL Message '" + msg.getQName() + "' is undefined. Check namespaces.", null);
            }
            if (msg.getParts().size() <= 1) continue;
            throw this.failure("deploy", "WSDL Message '" + msg.getQName() + "' has more than one part", null);
        }
        Collection imports = rootDef.getImports().values();
        for (List imps : imports) {
            for (Import imp : imps) {
                this.checkDefinition(imp.getDefinition(), false);
            }
        }
    }

    private Definition loadMainWsdl(String serviceUnitRootPath) throws WSDLException {
        File[] bpels = new File(serviceUnitRootPath).listFiles(this.filter);
        String bpel = bpels[0].getAbsoluteFile().toURI().toString();
        String wsdl = bpel.substring(0, bpel.length() - 4) + "wsdl";
        WSDLReader reader = WSDLFactory.newInstance().newWSDLReader();
        reader.setFeature("javax.wsdl.verbose", false);
        reader.setExtensionRegistry(this.getExtentionRegistry());
        return reader.readWSDL(null, wsdl);
    }

    private ExtensionRegistry getExtentionRegistry() {
        PopulatedExtensionRegistry er = new PopulatedExtensionRegistry();
        BPELPropertySerializer bpelPropSerializer = new BPELPropertySerializer();
        BPELPropertyAliasSerializer bpelPropAliasSerializer = new BPELPropertyAliasSerializer();
        BPEActionSerializer bpeActionSerializer = new BPEActionSerializer();
        BPEInputSerializer bpeInputSerializer = new BPEInputSerializer();
        BPEOutputSerializer bpeOutputSerializer = new BPEOutputSerializer();
        BPEFaultSerializer bpeFaultSerializer = new BPEFaultSerializer();
        BPEVariableMapSerializer bpeVariableSerializer = new BPEVariableMapSerializer();
        er.registerSerializer(Definition.class, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, (ExtensionSerializer)bpelPropSerializer);
        er.registerDeserializer(Definition.class, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, (ExtensionDeserializer)bpelPropSerializer);
        er.mapExtensionTypes(Definition.class, ExtentionConstants.Q_ELEM_BPEL_PROPERTY, BPELProperty.class);
        er.registerSerializer(Definition.class, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, (ExtensionSerializer)bpelPropAliasSerializer);
        er.registerDeserializer(Definition.class, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, (ExtensionDeserializer)bpelPropAliasSerializer);
        er.mapExtensionTypes(Definition.class, ExtentionConstants.Q_ELEM_BPEL_PROPERTY_ALIAS, BPELPropertyAlias.class);
        er.registerSerializer(BindingOperation.class, ExtentionConstants.Q_ELEM_BPE_ACTION, (ExtensionSerializer)bpeActionSerializer);
        er.registerDeserializer(BindingOperation.class, ExtentionConstants.Q_ELEM_BPE_ACTION, (ExtensionDeserializer)bpeActionSerializer);
        er.mapExtensionTypes(BindingOperation.class, ExtentionConstants.Q_ELEM_BPE_ACTION, BPEAction.class);
        er.registerSerializer(BindingInput.class, ExtentionConstants.Q_ELEM_BPE_INPUT, (ExtensionSerializer)bpeInputSerializer);
        er.registerDeserializer(BindingInput.class, ExtentionConstants.Q_ELEM_BPE_INPUT, (ExtensionDeserializer)bpeInputSerializer);
        er.mapExtensionTypes(BindingInput.class, ExtentionConstants.Q_ELEM_BPE_INPUT, BPEInput.class);
        er.registerSerializer(BindingOutput.class, ExtentionConstants.Q_ELEM_BPE_OUTPUT, (ExtensionSerializer)bpeOutputSerializer);
        er.registerDeserializer(BindingOutput.class, ExtentionConstants.Q_ELEM_BPE_OUTPUT, (ExtensionDeserializer)bpeOutputSerializer);
        er.mapExtensionTypes(BindingOutput.class, ExtentionConstants.Q_ELEM_BPE_OUTPUT, BPEOutput.class);
        er.registerSerializer(BindingFault.class, ExtentionConstants.Q_ELEM_BPE_FAULT, (ExtensionSerializer)bpeFaultSerializer);
        er.registerDeserializer(BindingFault.class, ExtentionConstants.Q_ELEM_BPE_FAULT, (ExtensionDeserializer)bpeFaultSerializer);
        er.mapExtensionTypes(BindingFault.class, ExtentionConstants.Q_ELEM_BPE_FAULT, BPEFault.class);
        er.registerSerializer(Definition.class, ExtentionConstants.Q_ELEM_BPE_VAR, (ExtensionSerializer)bpeVariableSerializer);
        er.registerDeserializer(Definition.class, ExtentionConstants.Q_ELEM_BPE_VAR, (ExtensionDeserializer)bpeVariableSerializer);
        er.mapExtensionTypes(Definition.class, ExtentionConstants.Q_ELEM_BPE_VAR, BPEVariableMap.class);
        return er;
    }

    public static class BpelFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(".bpel");
        }
    }
}

