/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe.external;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpe.action.bpel.ExternalServiceAction;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.WSDLOperationKey;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.util.BPException;

public class JbiExternalAction
extends ExternalServiceAction {
    public static final String SM_NS = "http://servicemix.apache.org/schemas/bpe/1.0";
    public static final String SM_ENDPOINT = "endpoint";
    public static final String SM_SERVICE = "service";
    public static final String SM_MEP = "mep";
    private static final Log LOG = LogFactory.getLog(JbiExternalAction.class);

    public void init(Properties props) throws BPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"init");
        }
        this.extractInformations(props);
        props.remove("operation_key");
        super.init(props);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("properties: " + props));
        }
    }

    protected void extractInformations(Properties properties) {
        Properties extProps = (Properties)properties.get("external_action_properties");
        BPELAttributes attrs = (BPELAttributes)properties.get("invoke_attributes");
        WSDLOperationKey opKey = (WSDLOperationKey)properties.get("operation_key");
        extProps.setProperty("interfaceNamespace", opKey.getNameSpace());
        extProps.setProperty("interfaceLocalName", opKey.getPortType());
        extProps.setProperty("operationNamespace", opKey.getNameSpace());
        extProps.setProperty("operationLocalName", opKey.getOperationName());
        Enumeration en = attrs.propertyNames();
        while (en.hasMoreElements()) {
            String[] parts;
            String qn = (String)en.nextElement();
            String uri = attrs.getURI(qn);
            String val = attrs.getProperty(qn);
            if (!SM_NS.equals(uri)) continue;
            if (qn.indexOf(58) > 0) {
                qn = qn.substring(qn.indexOf(58) + 1);
            }
            if (SM_ENDPOINT.equals(qn)) {
                parts = this.split3(val);
                extProps.setProperty("serviceNamespace", parts[0]);
                extProps.setProperty("serviceLocalName", parts[1]);
                extProps.setProperty("endpointName", parts[2]);
                continue;
            }
            if (SM_SERVICE.equals(qn)) {
                parts = this.split2(val);
                extProps.setProperty("serviceNamespace", parts[0]);
                extProps.setProperty("serviceLocalName", parts[1]);
                continue;
            }
            if (!SM_MEP.equals(qn)) continue;
            extProps.setProperty(SM_MEP, val);
        }
    }

    protected String[] split3(String uri) {
        int sep = uri.indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        int idx2 = uri.lastIndexOf(sep, idx1 - 1);
        String epName = uri.substring(idx1 + 1);
        String svcName = uri.substring(idx2 + 1, idx1);
        String nsUri = uri.substring(0, idx2);
        return new String[]{nsUri, svcName, epName};
    }

    protected String[] split2(String uri) {
        int sep = uri.indexOf(47) > 0 ? 47 : 58;
        int idx1 = uri.lastIndexOf(sep);
        String svcName = uri.substring(idx1 + 1);
        String nsUri = uri.substring(0, idx1);
        return new String[]{nsUri, svcName};
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        return super.execute(resolver, ec, pcb, processInstance, processDefinition);
    }
}

