/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicemix.bpe.timer;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpe.event.ITimerEvent;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.timerservice.IBPETimerService;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.servicemix.bpe.BPEEndpoint;
import org.apache.servicemix.bpe.timer.BPETimerJdk;

public class BPETimerServiceJdk
implements IBPETimerService {
    private static final Log LOG = LogFactory.getLog(BPETimerServiceJdk.class);
    private static Timer timer;

    public IBPETimer createTimer(long startDuration, ITimerEvent timerEvent) throws BPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Schedule timer " + timerEvent + " for " + startDuration));
        }
        BPETimerJdk tt = new BPETimerJdk(timerEvent, BPEEndpoint.getCurrent());
        timer.schedule((TimerTask)tt, startDuration);
        return tt;
    }

    public IBPETimer createTimer(Date startTime, ITimerEvent timerEvent) throws BPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Schedule timer " + timerEvent + " at " + startTime));
        }
        BPETimerJdk tt = new BPETimerJdk(timerEvent, BPEEndpoint.getCurrent());
        timer.schedule((TimerTask)tt, startTime);
        return tt;
    }

    public void removeTimer(IBPETimer tmr) throws BPException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Timer " + tmr.getTimerEvent() + " cancelled"));
        }
        ((BPETimerJdk)tmr).cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BPEProperties props) throws BPException {
        Class<BPETimerServiceJdk> clazz = BPETimerServiceJdk.class;
        synchronized (BPETimerServiceJdk.class) {
            if (timer == null) {
                timer = new Timer();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

