/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.external;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.ode.bpe.action.external.IExternalAction;
import org.apache.ode.bpe.action.external.IURIResolver;
import org.apache.ode.bpe.action.external.TransformerURIResolver;
import org.apache.ode.bpe.scope.service.BPRuntimeException;

public class XSLTranslatorAction
implements IExternalAction {
    static final long serialVersionUID = -989300275891390371L;
    public static final String FORMAT_KEY = "instructions";
    public static final String SOURCE_PART_KEY = "rootSourcePart";
    public static final String TARGET_PART_KEY = "targetPart";
    public static final String FAULT_NAME = "xsltFault";
    private Transformer m_transformer;
    private String m_sourcePart;
    private String m_targetPart;
    private String m_xsltDoc;
    private TransformerURIResolver m_transResolver;

    public void init(Properties props) throws BPRuntimeException {
        this.m_sourcePart = props.getProperty(SOURCE_PART_KEY);
        this.m_targetPart = props.getProperty(TARGET_PART_KEY);
        this.m_xsltDoc = props.getProperty(FORMAT_KEY);
    }

    public void execute(HashMap input, HashMap output, IURIResolver resolver) throws BPRuntimeException {
        try {
            if (this.m_transformer == null) {
                this.initTransformer(resolver);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(baos);
            this.m_transResolver.setDataMap(input);
            this.m_transformer.transform(this.m_transResolver.getData(this.m_sourcePart), result);
            output.put(this.m_targetPart, baos.toByteArray());
        }
        catch (TransformerException e) {
            throw new BPRuntimeException(FAULT_NAME, "NATIVE_EXCEPTION", null, e);
        }
        catch (Exception e) {
            throw new BPRuntimeException(FAULT_NAME, "NATIVE_EXCEPTION", null, e);
        }
    }

    public void initTransformer(IURIResolver resolver) throws BPRuntimeException {
        this.m_transResolver = new TransformerURIResolver(resolver);
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            String instSet = (String)resolver.getArtifact(this.m_xsltDoc);
            StreamSource stylesource = new StreamSource(new StringReader(instSet));
            this.m_transformer = tFactory.newTransformer(stylesource);
            this.m_transformer.setURIResolver(this.m_transResolver);
        }
        catch (TransformerConfigurationException e) {
            throw new BPRuntimeException(FAULT_NAME, "NATIVE_EXCEPTION", null, e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new BPRuntimeException(FAULT_NAME, "NATIVE_EXCEPTION", null, e);
        }
    }

    public void release() {
        this.m_transformer = null;
    }
}

