/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorException;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.bped.managed.BPEventDirector;
import org.apache.ode.bpe.bped.managed.BPEventDirectorHome;
import org.apache.ode.bpe.bped.managed.BPEventDirectorLocal;
import org.apache.ode.bpe.bped.managed.BPEventDirectorLocalHome;
import org.apache.ode.bpe.bped.managed.EventDirectorLocal;
import org.apache.ode.bpe.bped.managed.EventDirectorRemote;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.correlation.CorrelationServiceFactory;
import org.apache.ode.bpe.definition.service.managed.ProcessDefinition;
import org.apache.ode.bpe.definition.service.managed.ProcessDefinitionHome;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.enginestate.service.EngineStateFactory;
import org.apache.ode.bpe.inmemory.jndi.IMContext;
import org.apache.ode.bpe.locking.LockingService;
import org.apache.ode.bpe.locking.LockingServiceFactory;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;
import org.apache.ode.bpe.uuid.UUIDServiceFactory;

public class EventDirectorFactory {
    public static final String IM_ENGINE_PROPERTY_FILE_NAME = "odeEngine.properties";
    public static final String JNFI = "java.naming.factory.initial";
    public static final String IMJNFI = "org.apache.ode.bpe.inmemory.jndi.IMContextFactory";
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$EventDirectorFactory == null ? (class$org$apache$ode$bpe$bped$EventDirectorFactory = EventDirectorFactory.class$("org.apache.ode.bpe.bped.EventDirectorFactory")) : class$org$apache$ode$bpe$bped$EventDirectorFactory).getName());
    private static UUIDService us;
    private static EventDirector cachedEventDirector;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$EventDirectorFactory;
    static /* synthetic */ Class class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionHome;
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$managed$BPEventDirectorHome;

    public static EventDirector createEventDirector() throws BPException {
        return EventDirectorFactory.createEventDirector("BPE");
    }

    public static EventDirector createEventDirector(String pkgName) throws BPException {
        boolean remote = true;
        String val = System.getProperty(JNFI);
        if (val != null && val.compareTo(IMJNFI) == 0) {
            remote = false;
        }
        if (remote) {
            return EventDirectorFactory.createRemoteEventDirector(pkgName);
        }
        return EventDirectorFactory.createInMemoryEventDirector();
    }

    public static synchronized EventDirector createEventDirectorCached(String pkgName) throws BPException {
        if (cachedEventDirector != null) {
            return cachedEventDirector;
        }
        return EventDirectorFactory.createEventDirector(pkgName);
    }

    public static synchronized EventDirector createEventDirectorCached() throws BPException {
        if (cachedEventDirector != null) {
            return cachedEventDirector;
        }
        return EventDirectorFactory.createEventDirector();
    }

    private static EventDirector createInMemoryEventDirector() throws BPException {
        us = UUIDServiceFactory.createUUIDService();
        BPEProperties props = new BPEProperties();
        try {
            IMContext.getProperties(props, IM_ENGINE_PROPERTY_FILE_NAME);
        }
        catch (IOException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"IOException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        cachedEventDirector = EventDirectorFactory.createEventDirector(props);
        return cachedEventDirector;
    }

    public static EventDirector createEventDirector(BPEProperties props) throws BPException {
        IInternalEventDirector ed = null;
        try {
            Class<?> instClass = Class.forName(props.getEventDirectorClass());
            ed = (IInternalEventDirector)instClass.newInstance();
            props.setProperty(EngineStateFactory.ENGINE_NAME, "BPE_ENGINE_" + ed.hashCode());
            if (us == null) {
                us = UUIDServiceFactory.createUUIDService(props);
            }
            ProcessService ps = new ProcessService(props, us);
            CorrelationService cs = CorrelationServiceFactory.createCorrelationService(props, ps);
            LockingService ls = LockingServiceFactory.createLockingService(props);
            ed.init(props, ps, cs, us, ls);
        }
        catch (ClassNotFoundException e) {
            EventDirectorException bpx = new EventDirectorException("CLASS_NOT_FOUND", new Object[]{props.getEventDirectorClass()});
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (InstantiationException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"InstantiationException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (IllegalAccessException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"IllegalAccessException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return (EventDirector)((Object)ed);
    }

    public static EventDirector createRemoteEventDirector() throws BPException {
        return EventDirectorFactory.createRemoteEventDirector(false);
    }

    public static EventDirector createRemoteEventDirector(boolean localBPED) throws BPException {
        return EventDirectorFactory.createRemoteEventDirector("BPE", localBPED);
    }

    public static EventDirector createRemoteEventDirector(String pkgName) throws BPException {
        return EventDirectorFactory.createRemoteEventDirector(pkgName, false);
    }

    public static EventDirector createRemoteEventDirector(String pkgName, boolean localBPED) throws BPException {
        EventDirector ed = null;
        try {
            InitialContext ic = new InitialContext();
            Object o = ic.lookup(pkgName + "/ProcessDefinition");
            ProcessDefinitionHome pdHome = (ProcessDefinitionHome)PortableRemoteObject.narrow((Object)o, (Class)(class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionHome == null ? (class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionHome = EventDirectorFactory.class$("org.apache.ode.bpe.definition.service.managed.ProcessDefinitionHome")) : class$org$apache$ode$bpe$definition$service$managed$ProcessDefinitionHome));
            ProcessDefinition pd = pdHome.create();
            if (localBPED) {
                BPEventDirectorLocalHome bpedLocalHome = (BPEventDirectorLocalHome)ic.lookup("java:comp/env/theLocalBPEDBean");
                BPEventDirectorLocal bpedLocal = bpedLocalHome.create();
                ed = new EventDirectorLocal(bpedLocal, pd);
            } else {
                o = ic.lookup(pkgName + "/BPEventDirector");
                BPEventDirectorHome bpedHome = (BPEventDirectorHome)PortableRemoteObject.narrow((Object)o, (Class)(class$org$apache$ode$bpe$bped$managed$BPEventDirectorHome == null ? (class$org$apache$ode$bpe$bped$managed$BPEventDirectorHome = EventDirectorFactory.class$("org.apache.ode.bpe.bped.managed.BPEventDirectorHome")) : class$org$apache$ode$bpe$bped$managed$BPEventDirectorHome));
                BPEventDirector bped = bpedHome.create();
                ed = new EventDirectorRemote(bped, pd);
            }
        }
        catch (ClassCastException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"ClassCastException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (RemoteException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"RemoteException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (NamingException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"NamingException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        catch (CreateException e) {
            EventDirectorException bpx = new EventDirectorException("NATIVE_EXCEPTION", new Object[]{"CreateException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return ed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

