/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.client.impl;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ode.bpe.bped.DeployTypeEnum;
import org.apache.ode.bpe.bped.EventDirector;
import org.apache.ode.bpe.bped.EventDirectorFactory;
import org.apache.ode.bpe.bped.IDeployer;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.EngineState;
import org.apache.ode.bpe.cc.client.IBPELBundle;
import org.apache.ode.bpe.cc.client.IBundle;
import org.apache.ode.bpe.cc.client.IDefinition;
import org.apache.ode.bpe.cc.client.IDefinitionQuery;
import org.apache.ode.bpe.cc.client.IEngine;
import org.apache.ode.bpe.cc.client.IInstance;
import org.apache.ode.bpe.cc.client.UnsupportedBundleException;
import org.apache.ode.bpe.cc.client.impl.Definition;
import org.apache.ode.bpe.cc.client.impl.Instance;
import org.apache.ode.bpe.cc.data.DefinitionData;
import org.apache.ode.bpe.cc.data.EngineData;
import org.apache.ode.bpe.cc.data.InstanceData;
import org.apache.ode.bpe.cc.service.CCServiceFactory;
import org.apache.ode.bpe.cc.service.ICCService;
import org.apache.ode.bpe.util.BPException;

public class Engine
implements IEngine {
    private ICCService m_CCService = null;
    private EngineData m_data = null;
    private HashMap iCreationalParameters;

    Engine(HashMap iCreationalParameters) throws CCException {
        this.iCreationalParameters = iCreationalParameters;
        String engineName = (String)iCreationalParameters.get("ENGINE_NAME");
        this.m_CCService = engineName != null ? CCServiceFactory.newInstance().createCCService(engineName) : CCServiceFactory.newInstance().createCCService();
        this.m_data = this.getService().getEngineData();
    }

    ICCService getService() {
        return this.m_CCService;
    }

    public void pause() throws CCException {
        this.getService().pauseEngine();
    }

    public void resume() throws CCException {
        this.getService().resumeEngine();
    }

    public EngineState getState() throws CCException {
        return this.m_data.getState();
    }

    public Collection getDefinitions() throws CCException {
        Collection defData = this.getService().getDefinitionData();
        Iterator defDataIter = defData.iterator();
        LinkedList<Definition> definitions = new LinkedList<Definition>();
        while (defDataIter.hasNext()) {
            Definition newDef = new Definition(this.getService(), this, (DefinitionData)defDataIter.next());
            definitions.add(newDef);
        }
        return definitions;
    }

    public void deployBundle(IBundle source) throws CCException {
        block5: {
            try {
                EventDirector eventDirector = this.iCreationalParameters != null && this.iCreationalParameters.get("ENGINE_NAME") != null ? EventDirectorFactory.createEventDirectorCached((String)this.iCreationalParameters.get("ENGINE_NAME")) : EventDirectorFactory.createEventDirectorCached();
                if (source instanceof IBPELBundle) {
                    IBPELBundle bpelBundle = (IBPELBundle)source;
                    IDeployer deployer = eventDirector.getDeployer(DeployTypeEnum.BPEL);
                    if (bpelBundle.isStream()) {
                        deployer.loadDefinition(bpelBundle.getAsInputStream(), false);
                    } else {
                        deployer.loadDefinition(bpelBundle.getResourcePath(), false);
                    }
                    break block5;
                }
                throw new UnsupportedBundleException();
            }
            catch (BPException e) {
                throw new CCException(e);
            }
        }
    }

    public void cleanupNow() throws CCException {
        this.getService().cleanupNow();
    }

    public IInstance getInstance(String iInstanceID) throws CCException {
        InstanceData instanceData = this.getService().getInstanceData(iInstanceID);
        DefinitionData dd = this.getService().getDefinitionForInstance(iInstanceID);
        Definition def = new Definition(this.getService(), this, dd);
        Instance instance = new Instance(this.getService(), def, instanceData);
        return instance;
    }

    public String getName() throws CCException {
        String engineName = this.m_data.getName();
        return engineName;
    }

    public String getID() throws CCException {
        String id = this.m_data.getID();
        return id;
    }

    public IDefinition getDefinition(IDefinitionQuery query) throws CCException {
        String definitionName = query.getQueryProperties().getProperty("DefinitionName");
        DefinitionData defData = this.getService().getDefinitionData(definitionName);
        Definition newDef = new Definition(this.getService(), this, defData);
        return newDef;
    }

    public void cleanup(Date iCompletionDate) throws CCException {
        this.getService().cleanCompletedSince(iCompletionDate);
    }

    public void setAutomaticCleanup(boolean iAutomaticCleanup) throws CCException {
        this.getService().setAutomaticCleanup(iAutomaticCleanup);
    }

    public boolean getAutomaticCleanup() {
        return this.m_data.getAutomaticCleanup();
    }

    public Map getStatistics() throws CCException {
        Map statistics = this.getService().getEngineStatistics(this.m_data);
        return statistics;
    }

    public boolean isBootstrapped() throws CCException {
        Collection defs = this.getDefinitions();
        return defs.size() > 0;
    }
}

