/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.client.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.IDefinition;
import org.apache.ode.bpe.cc.client.IInstance;
import org.apache.ode.bpe.cc.client.IScope;
import org.apache.ode.bpe.cc.client.InstanceState;
import org.apache.ode.bpe.cc.client.impl.Definition;
import org.apache.ode.bpe.cc.client.impl.Registration;
import org.apache.ode.bpe.cc.client.impl.Scope;
import org.apache.ode.bpe.cc.client.impl.ServiceNode;
import org.apache.ode.bpe.cc.data.InstanceData;
import org.apache.ode.bpe.cc.data.RegistrationData;
import org.apache.ode.bpe.cc.data.ScopeData;
import org.apache.ode.bpe.cc.service.ICCService;

public class Instance
extends ServiceNode
implements IInstance {
    IDefinition m_definition;
    InstanceData m_data;

    public Instance(ICCService service, Definition definition, InstanceData instanceData) {
        super(service);
        this.m_definition = definition;
        this.m_data = instanceData;
    }

    public void pause() throws CCException {
        this.getService().pauseInstance(this.m_data);
    }

    public void terminate() throws CCException {
        this.getService().terminateInstance(this.m_data);
    }

    public void resume() throws CCException {
        this.getService().resumeInstance(this.m_data);
    }

    public void remove() throws CCException {
        this.getService().removeInstance(this.m_data);
    }

    public InstanceState getState() throws CCException {
        return this.m_data.getState();
    }

    public String getID() throws CCException {
        return this.m_data.getID();
    }

    public IDefinition getDefinition() throws CCException {
        return this.m_definition;
    }

    public IScope getRootContext() throws CCException {
        ScopeData cdata = this.getService().getContextScopeData(this.m_data);
        if (cdata == null) {
            return null;
        }
        Scope newScope = new Scope(this.getService(), this, cdata);
        return newScope;
    }

    public Collection getRegistrations() throws CCException {
        Collection registrations = this.getService().getRegistrations(this.m_data);
        LinkedList<Registration> regList = new LinkedList<Registration>();
        Iterator iter = registrations.iterator();
        while (iter.hasNext()) {
            RegistrationData rd = (RegistrationData)iter.next();
            Registration newRegistration = new Registration(this, rd);
            regList.add(newRegistration);
        }
        return regList;
    }

    public Map getStatistics() throws CCException {
        Map statistics = this.getService().getInstanceStatistics(this.m_data);
        return statistics;
    }
}

