/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.apache.ode.bpe.cc.client.BPELBundle;
import org.apache.ode.bpe.cc.client.CCClient;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.IEngine;
import org.apache.ode.bpe.client.exceptions.SystemException;
import org.apache.ode.bpe.client.result.IResult;
import org.apache.ode.bpe.client.util.IBPEInvoker;
import org.apache.ode.bpe.client.util.InvokerBuilder;
import org.apache.ode.bpe.util.BPException;

public class EngineUtil {
    private File defJar;
    private ArrayList invocations = new ArrayList();
    private String[] args;
    private IResult result = null;
    private String packageName = "BPE";

    public static void main(String[] args) {
        EngineUtil eu = new EngineUtil(args);
        eu.run();
    }

    public EngineUtil(String[] args) {
        this.args = args;
    }

    private void setup() throws BPException {
        this.parseCmdLine(this.args);
    }

    private void deploy() throws FileNotFoundException, BPException, CCException {
        if (this.defJar != null) {
            FileInputStream jarDefStream = new FileInputStream(this.defJar);
            BPELBundle bpelBundle = new BPELBundle(this.defJar.getName(), jarDefStream);
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("ENGINE_NAME", this.packageName);
            CCClient ccClient = new CCClient();
            IEngine engine = ccClient.getEngine(hm);
            engine.deployBundle(bpelBundle);
        }
    }

    private void sendMessages() throws Exception {
        Iterator it = ((AbstractList)this.invocations).iterator();
        InvokerBuilder ib = new InvokerBuilder(this.packageName);
        while (it.hasNext()) {
            Properties invocation = new Properties();
            invocation.load(new FileInputStream((File)it.next()));
            IBPEInvoker bpi = ib.buildInvoker(invocation);
            this.result = bpi.invoke();
            this.dumpResult();
        }
    }

    private void dumpResult() {
        System.out.println("Return message:");
        System.out.println(this.result.toString());
    }

    public void run() {
        try {
            this.setup();
            this.deploy();
            this.sendMessages();
        }
        catch (Exception e) {
            if (e instanceof SystemException) {
                System.out.println("A system exception has occurred:");
            }
            e.printStackTrace();
        }
    }

    private void parseCmdLine(String[] args) {
        try {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].equals("-h")) {
                    this.help();
                    continue;
                }
                if (args[i].equals("-p")) {
                    this.packageName = args[++i];
                    continue;
                }
                if (args[i].equals("-d")) {
                    this.defJar = new File(args[++i]);
                    if (this.defJar.isFile() && this.defJar.canRead()) continue;
                    this.help();
                    continue;
                }
                while (i < args.length) {
                    File f = new File(args[i]);
                    if (f.isFile() && f.canRead()) {
                        this.invocations.add(f);
                    } else {
                        this.help();
                    }
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            this.help();
        }
    }

    private void help() {
        System.out.println("EnginUtil [-p packageName] [-d deployFile] [msgFile]...");
        System.out.println("-p the engines package name, default is BPE");
        System.out.println("-d deployFile - the definition deploy zip file ");
        System.out.println("Specifiy 0..n message to send");
        System.exit(0);
    }
}

