/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.ejb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;
import org.apache.ode.bpe.context.base.INoThrowDataObject;
import org.apache.ode.bpe.context.ejb.CachedObject;
import org.apache.ode.bpe.context.ejb.FlushCommand;
import org.apache.ode.bpe.context.ejb.ObjectCache;
import org.apache.ode.bpe.util.ObjectInputStreamContextClassLoader;
import org.apache.ode.bpe.util.TraceLog;

public abstract class BPE_CMPObjectBean
implements EntityBean,
INoThrowDataObject {
    static final long serialVersionUID = -6675363464240432410L;
    protected Object m_object = null;
    private ClassLoader m_contextClassLoader;
    private long m_currentDataUpdateCount = -1L;
    private boolean m_dirtyDataBit = false;
    private boolean m_objectStale = true;
    private boolean m_shouldIncrementUpdateCountOnStore = true;
    private ObjectCache objectCache;
    protected static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$context$ejb$BPE_CMPObjectBean == null ? (class$org$apache$ode$bpe$context$ejb$BPE_CMPObjectBean = BPE_CMPObjectBean.class$("org.apache.ode.bpe.context.ejb.BPE_CMPObjectBean")) : class$org$apache$ode$bpe$context$ejb$BPE_CMPObjectBean).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$context$ejb$BPE_CMPObjectBean;

    public abstract String getId();

    public abstract void setId(String var1);

    public abstract byte[] getData();

    public abstract void setData(byte[] var1);

    public abstract long getRefCount();

    public abstract void setRefCount(long var1);

    public abstract long getDataUpdateCount();

    public abstract void setDataUpdateCount(long var1);

    public void ejbActivate() throws EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::ejbActivate()");
        }
        this.init();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::ejbActivate()");
        }
    }

    public void ejbLoad() throws EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::ejbLoad()");
        }
        this.restoreCachedState();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::ejbLoad()");
        }
    }

    private void restoreCachedState() {
        String id = this.getId();
        long updateCount = this.getDataUpdateCount();
        this.prepareContextClassLoader();
        CachedObject cobj = (CachedObject)this.objectCache.get(id);
        if (cobj != null && cobj.getUpdateCount() == updateCount) {
            this.m_object = cobj.getObject();
            this.m_objectStale = false;
        } else {
            this.m_objectStale = true;
        }
        this.m_currentDataUpdateCount = updateCount;
    }

    private void prepareContextClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader == null) {
            Thread.currentThread().setContextClassLoader(this.m_contextClassLoader);
        }
    }

    private void cacheState() {
        this.prepareContextClassLoader();
        CachedObject co = new CachedObject(this.m_object, this.getDataUpdateCount());
        this.objectCache.put(this.getId(), co);
    }

    public void ejbPassivate() throws EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::ejbPassivate()");
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::ejbPassivate()");
        }
    }

    public void ejbRemove() throws RemoveException, EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::ejbRemove()");
        }
        this.prepareContextClassLoader();
        this.objectCache.remove(this.getId());
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::ejbRemove()");
        }
    }

    public void ejbStore() throws EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::ejbStore()");
        }
        if (this.isDirty()) {
            if (this.getShouldIncrementUpdateCountOnStore()) {
                ++this.m_currentDataUpdateCount;
                this.internalSetDataUpdateCount(this.m_currentDataUpdateCount++);
            } else {
                this.setShouldIncrementUpdateCountOnStore(true);
            }
            this.marshalToStorage();
            this.internalClearDirtyDataBit();
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::ejbStore()");
        }
    }

    private void internalSetDataUpdateCount(long dataUpdateCount) {
        long generatedUpdateCount = ObjectCache.GetUpdateCount(dataUpdateCount);
        this.setDataUpdateCount(generatedUpdateCount);
    }

    private byte[] getObjectAsByteArray() throws IOException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::getObjectAsByteArray()");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this.internalGetObject());
        oos.close();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::getObjectAsByteArray()");
        }
        return baos.toByteArray();
    }

    protected void marshalToStorage() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::marshalToStorage()");
        }
        try {
            byte[] byteArray = this.getObjectAsByteArray();
            this.setData(byteArray);
            this.cacheState();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            if (TraceLog.enabled()) {
                this.exitTrace("BPE_CMPObjectBean::marshalToStorage()");
            }
            throw new EJBException((Exception)e);
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::marshalToStorage()");
        }
    }

    public void setEntityContext(EntityContext ctx) throws EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::setEntityContext(EntityContext ctx)");
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::setEntityContext(EntityContext ctx)");
        }
    }

    public void unsetEntityContext() throws EJBException {
        if (TraceLog.enabled()) {
            this.enterTrace("unsetEntityContext()");
        }
        if (TraceLog.enabled()) {
            this.exitTrace("unsetEntityContext()");
        }
    }

    public String ejbCreate(String id, Object iObject) throws CreateException {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::BPE_CMPObjectBean::ejbCreate(java.lang.String id, Object iObject)");
        }
        this.init();
        this.setId(id);
        this.internalSetDataUpdateCount(1L);
        this.setShouldIncrementUpdateCountOnStore(false);
        this.setObjectNow(iObject);
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::BPE_CMPObjectBean::ejbCreate(java.lang.String id, Object iObject)");
        }
        return id;
    }

    private void init() {
        this.m_object = null;
        this.m_currentDataUpdateCount = -1L;
        this.m_dirtyDataBit = false;
        this.m_objectStale = true;
        this.m_shouldIncrementUpdateCountOnStore = true;
        if (this.objectCache == null) {
            this.objectCache = new ObjectCache();
        }
    }

    public void ejbPostCreate(String id, Object iObject) {
    }

    public void decrementRefCount() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::decrementRefCount()");
        }
        this.setRefCount(this.getRefCount() - 1L);
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::decrementRefCount()");
        }
    }

    public void incrementRefCount() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::incrementRefCount()");
        }
        this.setRefCount(this.getRefCount() + 1L);
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::incrementRefCount()");
        }
    }

    private boolean isObjectStale() {
        return this.m_objectStale;
    }

    private Object internalGetFreshObject() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::internalGetFreshObject()");
        }
        if (this.isObjectStale()) {
            this.restoreCachedState();
            if (this.isObjectStale()) {
                this.marshalFromStorage();
                this.m_objectStale = false;
            }
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::internalGetFreshObject()");
        }
        return this.m_object;
    }

    protected void marshalFromStorage() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::marshalFromStorage()");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.getData());
            ObjectInputStreamContextClassLoader ois = new ObjectInputStreamContextClassLoader(bais);
            this.internalSetObject(ois.readObject());
            ois.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "", e);
            if (TraceLog.enabled()) {
                this.exitTrace("BPE_CMPObjectBean::marshalFromStorage()");
            }
            throw new EJBException((Exception)e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "", e);
            if (TraceLog.enabled()) {
                this.exitTrace("BPE_CMPObjectBean::marshalFromStorage()");
            }
            throw new EJBException((Exception)e);
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::marshalFromStorage()");
        }
    }

    public Object getObjectForRead() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::getObjectForRead()");
        }
        Object obj = this.internalGetFreshObject();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::getObjectForRead()");
        }
        return obj;
    }

    public Object getObjectForReadWrite() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::getObjectForReadWrite()");
        }
        this.internalSetDirtyDataBit();
        Object obj = this.internalGetFreshObject();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::getObjectForReadWrite()");
        }
        return obj;
    }

    public void setObject(Object data) {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::setObject( Object data ) ");
        }
        if (data instanceof FlushCommand) {
            this.marshalToStorage();
        } else {
            this.internalSetObject(data);
            this.internalSetDirtyDataBit();
        }
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::setObject( Object data ) ");
        }
    }

    public void setObjectNow(Object data) {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::setObjectNow()");
        }
        this.internalSetObject(data);
        this.marshalToStorage();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::setObjectNow()");
        }
    }

    protected void internalSetObject(Object iData) {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::internalSetObject()");
        }
        this.m_object = iData;
        this.cacheState();
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::internalSetObject()");
        }
    }

    protected Object internalGetObject() {
        return this.m_object;
    }

    protected void internalSetDirtyDataBit() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::internalSetDirtyBit()");
        }
        this.m_dirtyDataBit = true;
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::internalSetDirtyBit()");
        }
    }

    protected void internalClearDirtyDataBit() {
        if (TraceLog.enabled()) {
            this.enterTrace("BPE_CMPObjectBean::internalClearDirtyBit()");
        }
        this.m_dirtyDataBit = false;
        if (TraceLog.enabled()) {
            this.exitTrace("BPE_CMPObjectBean::internalClearDirtyBit()");
        }
    }

    protected boolean isDirty() {
        return this.m_dirtyDataBit;
    }

    protected void enterTrace(String iFunction) {
        if (TraceLog.enabled()) {
            TraceLog.println(this.getDumpState(iFunction) + " Enter " + iFunction);
        }
    }

    protected void exitTrace(String iFunction) {
        if (TraceLog.enabled()) {
            TraceLog.println(this.getDumpState(iFunction) + " Exit " + iFunction);
        }
    }

    protected String getDumpScope(String iFunction) {
        return iFunction + " | ";
    }

    protected String getDumpState(String iFunction) {
        return "(TODO)";
    }

    protected void setShouldIncrementUpdateCountOnStore(boolean shouldIncrement) {
        this.m_shouldIncrementUpdateCountOnStore = shouldIncrement;
    }

    protected boolean getShouldIncrementUpdateCountOnStore() {
        return this.m_shouldIncrementUpdateCountOnStore;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

