/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.persistent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.ode.bpe.context.IHandle;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.DataObject;
import org.apache.ode.bpe.context.ejb.BPE_ObjectLocal;
import org.apache.ode.bpe.context.nonpersistent.TransientDataObject;
import org.apache.ode.bpe.context.persistent.PersistentContainer;
import org.apache.ode.bpe.context.persistent.PersistentDataObject;
import org.apache.ode.bpe.context.persistent.PersistentNode;

public class PersistentPart
extends PersistentNode
implements IPart,
Serializable {
    private static final long serialVersionUID = 1L;

    PersistentPart(String name, PersistentContainer parent) throws ContextServiceException {
        super(name, parent);
        this.setNodeType(1);
    }

    PersistentPart(String name, PersistentContainer parent, BPE_ObjectLocal local) throws ContextServiceException {
        super(name, parent);
        this.setNodeType(1);
    }

    PersistentPart(PersistentPart part, String name, PersistentContainer parent) throws ContextServiceException {
        super(name, parent);
        this.setNodeType(1);
    }

    PersistentPart() throws ContextServiceException {
        this.setNodeType(1);
    }

    protected void internalSetObject(Object iObject) throws ContextServiceException {
        super.internalSetObject(iObject);
    }

    protected void internalSetObject(IHandle iObjectHandle) throws ContextServiceException {
        super.internalSetObject(iObjectHandle);
    }

    public void setObject(Object iObject) throws ContextServiceException {
        this.setReadOnly(false);
        this.internalSetObject(iObject);
        this.setDirty(this);
    }

    public Object getObjectClone() throws ContextServiceException {
        return this.internalGetObjectClone();
    }

    public void setObjectHandle(IHandle iObjectHandle) throws ContextServiceException {
        this.setReadOnly(true);
        this.internalSetObject(iObjectHandle);
        this.setDirty(this);
    }

    public Object getObjectForRead() throws ContextServiceException {
        return this.internalGetObjectForRead();
    }

    public Object getObjectForReadWrite() throws ContextServiceException {
        if (super.getHandle() instanceof TransientDataObject) {
            this.setDirty(this);
        }
        return this.internalGetObjectForReadWrite();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.writeNodeElements(s);
        s.writeBoolean(this.getReadOnly());
        s.writeObject(this.getHandleForSerialization());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.readNodeElements(s);
        this.setReadOnly(s.readBoolean());
        DataObject dataObject = (DataObject)s.readObject();
        this.setHandleFromDeserialization(dataObject);
    }

    protected DataObject getHandle() throws ContextServiceException {
        PersistentDataObject pHandle;
        DataObject returnHandle = super.getHandle();
        if (returnHandle != null && returnHandle instanceof PersistentDataObject && (pHandle = (PersistentDataObject)returnHandle).isHollow()) {
            String locator = pHandle.getLocator();
            PersistentDataObject solidHandle = (PersistentDataObject)this.getService().findPersistentDataObject(locator);
            pHandle.fill(solidHandle);
        }
        return returnHandle;
    }

    protected void setHandle(DataObject iHandle) throws ContextServiceException {
        super.setHandle(iHandle);
    }
}

