/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.persistent;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.INode;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.base.IDataObject;
import org.apache.ode.bpe.context.base.SuperNode;
import org.apache.ode.bpe.context.persistent.PersistentContainer;
import org.apache.ode.bpe.context.persistent.PersistentContextService;
import org.apache.ode.bpe.context.persistent.PersistentNode;
import org.apache.ode.bpe.context.persistent.PersistentPart;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.util.TraceLog;

public class PersistentRootContainer
extends PersistentContainer {
    static final long serialVersionUID = -8541967577729422105L;
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$context$persistent$PersistentRootContainer == null ? (class$org$apache$ode$bpe$context$persistent$PersistentRootContainer = PersistentRootContainer.class$("org.apache.ode.bpe.context.persistent.PersistentRootContainer")) : class$org$apache$ode$bpe$context$persistent$PersistentRootContainer).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$context$persistent$PersistentRootContainer;

    PersistentRootContainer(PersistentContextService service) throws ContextServiceException {
        this.setService(service);
    }

    public IContainer createContainer(String iContainerLocator) throws ContextServiceException {
        PersistentContainer ret;
        if (TraceLog.enabled()) {
            TraceLog.println(this.getClass(), "Inside createContainer() : iContainerLocator = " + iContainerLocator);
        }
        if ((ret = this.checkLocalCacheForContainer(iContainerLocator)) == null) {
            IDataObject dataObject = this.getService().findPersistentDataObject(iContainerLocator);
            if (dataObject != null) {
                PersistentContainer pc = (PersistentContainer)dataObject.getObjectForRead();
                if (TraceLog.enabled()) {
                    TraceLog.println(this.getClass(), "Found child container with name = " + pc.getName());
                }
                this.initTree(pc, dataObject);
                return pc;
            }
            PersistentContainer newContainer = new PersistentContainer();
            IDataObject newDataObject = this.getService().createPersistentDataObject(iContainerLocator, newContainer);
            newDataObject.incrementRefCount();
            this.initNewTree(newContainer, newDataObject, iContainerLocator);
            return newContainer;
        }
        return ret;
    }

    public IPart createPart(String iPartLocator) throws ContextServiceException {
        PersistentPart ret = this.checkLocalCacheForPart(iPartLocator);
        if (ret == null) {
            IDataObject dataObject = this.getService().findPersistentDataObject(iPartLocator);
            if (dataObject != null) {
                PersistentPart pp = (PersistentPart)dataObject.getObjectForRead();
                this.initTree(pp, dataObject);
                return pp;
            }
            PersistentPart newPart = new PersistentPart();
            IDataObject newDataObject = this.getService().createPersistentDataObject(iPartLocator, newPart);
            this.initNewTree(newPart, newDataObject, iPartLocator);
            return newPart;
        }
        return ret;
    }

    private void initNewTree(PersistentNode iNode, IDataObject iDataObject, String iName) throws ContextServiceException {
        iNode.setName(iName);
        this.initTree(iNode, iDataObject);
    }

    private void initTree(PersistentNode iNode, IDataObject iDataObject) throws ContextServiceException {
        iNode.init(this);
        iNode.setMemento(iDataObject);
    }

    public INode findChild(String iChildLocator) throws ContextServiceException {
        IDataObject dataObject;
        PersistentNode ret = this.checkLocalCacheForContainer(iChildLocator);
        if (ret == null && (dataObject = this.getService().findPersistentDataObject(iChildLocator)) != null) {
            Object obj = dataObject.getObjectForRead();
            ret = (PersistentNode)obj;
            this.initTree(ret, dataObject);
        }
        return ret;
    }

    public void removeChild(String iChildLocator) throws ContextServiceException {
        super.internalRemoveChild(iChildLocator);
        this.getService().removePersistentDataObject(iChildLocator);
    }

    public void moveNode(INode iSourceNode, String iTargetName) throws ContextServiceException {
        ContextServiceException cse = new ContextServiceException("METHOD_UNSUPPORTED", new Object[]{"moveNode", (class$org$apache$ode$bpe$context$persistent$PersistentRootContainer == null ? (class$org$apache$ode$bpe$context$persistent$PersistentRootContainer = PersistentRootContainer.class$("org.apache.ode.bpe.context.persistent.PersistentRootContainer")) : class$org$apache$ode$bpe$context$persistent$PersistentRootContainer).toString()});
        cse.log(logger, Level.SEVERE);
        throw cse;
    }

    public Collection getChildren() throws ContextServiceException {
        return super.getChildren();
    }

    public IContainer getParent() throws ContextServiceException {
        String msg = ResourceGetter.getFormatted("METHOD_UNSUPPORTED", new Object[]{"getParent", (class$org$apache$ode$bpe$context$persistent$PersistentRootContainer == null ? (class$org$apache$ode$bpe$context$persistent$PersistentRootContainer = PersistentRootContainer.class$("org.apache.ode.bpe.context.persistent.PersistentRootContainer")) : class$org$apache$ode$bpe$context$persistent$PersistentRootContainer).toString()});
        logger.log(Level.WARNING, msg);
        return null;
    }

    PersistentNode getRoot(PersistentNode child) {
        return child;
    }

    public String getName() {
        return "ROOT";
    }

    protected void setDirty(SuperNode child) throws ContextServiceException {
        try {
            IDataObject dataObject = (IDataObject)child.getMemento();
            dataObject.setObject(child);
        }
        catch (ContextServiceException e) {
            if (TraceLog.enabled()) {
                TraceLog.println(this.getClass(), "Inside setDirty() : Exception occurred when attempting to mark data object as dirty : Data Object Locator = " + child.getName());
            }
            throw e;
        }
    }

    private PersistentContainer checkLocalCacheForContainer(String iContainerLocator) throws ContextServiceException {
        PersistentContainer ret = null;
        INode tmp = super.findChild(iContainerLocator);
        if (tmp != null) {
            if (!(tmp instanceof PersistentContainer)) {
                ContextServiceException cse = new ContextServiceException("TYPE_CAST", new Object[]{"IContainer", tmp.getClass().getName()});
                cse.log(logger, Level.SEVERE);
                throw cse;
            }
            ret = (PersistentContainer)tmp;
        }
        return ret;
    }

    private PersistentPart checkLocalCacheForPart(String iPartLocator) throws ContextServiceException {
        PersistentPart ret = null;
        INode tmp = super.findChild(iPartLocator);
        if (tmp != null) {
            if (!(tmp instanceof PersistentPart)) {
                ContextServiceException cse = new ContextServiceException("TYPE_CAST", new Object[]{"IContainer", tmp.getClass().getName()});
                cse.log(logger, Level.SEVERE);
                throw cse;
            }
            ret = (PersistentPart)tmp;
        }
        return ret;
    }

    protected void lockTree(SuperNode child) throws ContextServiceException {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

