/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.resolver;

import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.context.resolver.ResolverException;
import org.apache.ode.bpe.util.xpath.XPathBoolean;
import org.jaxen.UnresolvableException;
import org.jaxen.VariableContext;

public class ResolverVariableContext
implements VariableContext {
    private ContextResolver resolver;
    public static final String NULLVALUE_EXCEPTION = "NULLVALUE_EXCEPTION";

    public ResolverVariableContext(ContextResolver resolver) {
        this.resolver = resolver;
    }

    public Object getVariableValue(String namespaceUri, String prefix, String location) throws UnresolvableException {
        try {
            Object o = this.resolver.resolve(location).getValue();
            if (o != null) {
                if (o instanceof XPathBoolean) {
                    o = ((XPathBoolean)o).booleanValue() ? Boolean.TRUE : Boolean.FALSE;
                } else {
                    o = o.toString();
                    try {
                        Double d = new Double((String)o);
                        o = d;
                    }
                    catch (NumberFormatException e) {}
                }
            } else {
                throw new UnresolvableException("NULLVALUE_EXCEPTION: An error occurred accessing the following: " + this.resolver.getLoggingString(location) + " The variable value is null.");
            }
            return o;
        }
        catch (ResolverException e) {
            throw new UnresolvableException(e.getMessage());
        }
    }
}

