/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.serialimpl;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDChangeCondition_SerialImpl;
import org.apache.ode.bpe.definition.serialimpl.PMDRoot_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.uuid.UUIDService;

public class PMDProcess_SerialImpl
implements IPMDProcess,
Serializable {
    static final long serialVersionUID = 5087682783809845033L;
    private ProcessDefinitionKey key;
    private PMDRoot_SerialImpl root;
    private String label;
    private String description;
    private Vector changeConditions;
    private Vector observers;
    private PMDChangeCondition_SerialImpl preCondition;
    private transient UUIDService us;

    public PMDProcess_SerialImpl(String label, PMDRoot_SerialImpl root, UUIDService us) throws DefinitionServiceException {
        this.key = new ProcessDefinitionKey(us);
        this.root = root;
        this.label = label;
        this.us = us;
        this.changeConditions = new Vector();
        this.observers = new Vector();
        root.getProcessIndex().put(this.key, this);
    }

    public PMDProcess_SerialImpl() {
    }

    public ProcessDefinitionKey getKey() {
        return this.key;
    }

    public void setKey(ProcessDefinitionKey key) {
        this.key = key;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public IPMDChangeCondition createChangeCondition(String label, String conditionalClass) throws DefinitionServiceException {
        PMDChangeCondition_SerialImpl ret = new PMDChangeCondition_SerialImpl(label, conditionalClass, this.root);
        this.changeConditions.add(ret);
        return ret;
    }

    public void addChangeCondition(IPMDChangeCondition cc) {
        this.changeConditions.add(cc);
    }

    public IPMDChangeCondition createPrecondition(String label, String conditionalClass) throws DefinitionServiceException {
        this.preCondition = new PMDChangeCondition_SerialImpl(label, conditionalClass, this.root);
        return this.preCondition;
    }

    public void addObserverProcessPC(IPMDProcess process) throws DefinitionServiceException {
        this.observers.add(process);
    }

    public IPMDProcess createSubProcess(String label) throws DefinitionServiceException {
        PMDProcess_SerialImpl ret = new PMDProcess_SerialImpl(label, this.root, this.us);
        this.observers.add(ret);
        return ret;
    }

    public IPMDProcess createUnLinkedProcess(String label) throws DefinitionServiceException {
        return new PMDProcess_SerialImpl(label, this.root, this.us);
    }

    public Collection getSubProcesses() throws DefinitionServiceException {
        return this.observers;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getVersion() {
        return null;
    }

    public ProcessDefinitionKey getRootKey() {
        return this.root.getProcess().getKey();
    }

    public IPMDRoot getRoot() {
        return this.root;
    }

    public void setRoot(IPMDRoot root) {
        this.root = (PMDRoot_SerialImpl)root;
    }

    public Iterator getChangeConditions() {
        return ((AbstractList)this.changeConditions).iterator();
    }

    public IPMDChangeCondition getPrecondition() {
        return this.preCondition;
    }

    public void setPrecondition(IPMDChangeCondition preCond) {
        this.preCondition = (PMDChangeCondition_SerialImpl)preCond;
    }

    public Iterator getObserverProcessPC() {
        return ((AbstractList)this.observers).iterator();
    }

    public Vector getObserverCollection() {
        return this.observers;
    }

    public void setObserverCollection(Vector v) {
        this.observers = v;
    }

    public Vector getCCCollection() {
        return this.changeConditions;
    }

    public void setCCCollection(Vector v) {
        this.changeConditions = v;
    }
}

