/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.definition.service.unmanaged;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.serialimpl.PMDRoot_SerialImpl;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;

public abstract class DefinitionServiceBase
implements DefinitionService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$definition$service$unmanaged$DefinitionServiceBase == null ? (class$org$apache$ode$bpe$definition$service$unmanaged$DefinitionServiceBase = DefinitionServiceBase.class$("org.apache.ode.bpe.definition.service.unmanaged.DefinitionServiceBase")) : class$org$apache$ode$bpe$definition$service$unmanaged$DefinitionServiceBase).getName());
    private UUIDService uuidService;
    private BPEProperties props;
    protected HashMap defRegistrations = new HashMap();
    protected HashMap metaNonInstanceCreatingOperations = new HashMap();
    private Hashtable definitions = new Hashtable();
    private Hashtable newDefinitions = new Hashtable();
    static /* synthetic */ Class class$org$apache$ode$bpe$definition$service$unmanaged$DefinitionServiceBase;

    public void init(BPEProperties props, UUIDService us) {
        this.props = props;
        this.uuidService = us;
    }

    protected void deleteOperations(IPMDRoot root) throws BPException {
        IStaticKey key;
        IPMDOperation op;
        Iterator it = root.getInstanceCreatingOperations().iterator();
        while (it.hasNext()) {
            op = (IPMDOperation)it.next();
            key = op.getKey();
            ArrayList al = (ArrayList)this.defRegistrations.get(((Object)key).toString());
            al.remove(op);
        }
        it = root.getMetaNonInstanceCreatingOperations().iterator();
        while (it.hasNext()) {
            op = (IPMDOperation)it.next();
            key = op.getKey();
            this.metaNonInstanceCreatingOperations.remove(((Object)key).toString());
        }
    }

    public void deleteDefinition(ProcessDefinitionKey rootKey) throws BPException {
        IPMDRoot root = this.getRootDefinition(rootKey);
        this.deleteOperations(root);
        root.clearExternalAction();
        this.definitions.remove(rootKey);
    }

    public void loadDefintion(ProcessDefinitionKey procKey, IProcessCallBack pcb) throws BPException {
        ArrayList<IPMDOperation> al;
        IStaticKey key;
        IPMDOperation op;
        IPMDRoot root = this.getRootDefinition(procKey);
        Iterator it = root.getInstanceCreatingOperations().iterator();
        while (it.hasNext()) {
            op = (IPMDOperation)it.next();
            key = op.getKey();
            al = (ArrayList<IPMDOperation>)this.defRegistrations.get(((Object)key).toString());
            if (al == null) {
                al = new ArrayList<IPMDOperation>();
                this.defRegistrations.put(((Object)key).toString(), al);
            }
            al.add(op);
        }
        it = root.getMetaNonInstanceCreatingOperations().iterator();
        while (it.hasNext()) {
            op = (IPMDOperation)it.next();
            key = op.getKey();
            al = (ArrayList<IPMDOperation>)this.metaNonInstanceCreatingOperations.get(((Object)key).toString());
            if (al == null) {
                al = new ArrayList<IPMDOperation>();
                this.metaNonInstanceCreatingOperations.put(((Object)key).toString(), al);
            }
            al.add(op);
        }
    }

    public IPMDRoot getRootDefinition(String definitionKey) throws BPException {
        return this.getRootDefinition(new ProcessDefinitionKey(definitionKey));
    }

    public IPMDRoot getRootDefinition(ProcessDefinitionKey definitionKey) throws BPException {
        IPMDRoot root = (IPMDRoot)this.definitions.get(definitionKey);
        return root;
    }

    public IPMDProcess getProcessDefintion(ProcessDefinitionKey processKey, ProcessDefinitionKey rootKey) throws BPException {
        IPMDProcess ret = null;
        PMDRoot_SerialImpl root = (PMDRoot_SerialImpl)this.getRootDefinition(rootKey);
        if (root != null) {
            HashMap hm = root.getProcessIndex();
            ret = (IPMDProcess)hm.get(processKey);
        }
        return ret;
    }

    public IPMDRoot createRootDefinition(String label, String version, boolean isStateless) throws BPException {
        PMDRoot_SerialImpl root;
        Iterator it = this.getRootDefinitions().iterator();
        ArrayList<PMDRoot_SerialImpl> defsToDelete = new ArrayList<PMDRoot_SerialImpl>();
        while (it.hasNext()) {
            root = (PMDRoot_SerialImpl)it.next();
            if (!root.getLabel().equals(label) || !root.getVersion().equals(version)) continue;
            defsToDelete.add(root);
        }
        it = ((AbstractList)defsToDelete).iterator();
        while (it.hasNext()) {
            root = (PMDRoot_SerialImpl)it.next();
            logger.log(Level.WARNING, ResourceGetter.getFormatted("DEF_REPLACE", new Object[]{label, version}));
            this.deleteDefinition(root.getProcess().getKey());
        }
        PMDRoot_SerialImpl ret = new PMDRoot_SerialImpl(label, version, isStateless, this.uuidService, this.definitions, this.newDefinitions);
        return ret;
    }

    public Collection getRootDefinitions() throws BPException {
        return this.definitions.values();
    }

    public Collection getCorrelations(IStaticKey key) throws BPException {
        Collection corrls = (Collection)this.defRegistrations.get(((Object)key).toString());
        if (corrls == null) {
            return new ArrayList();
        }
        return corrls;
    }

    public BPEProperties getBPEProperties() {
        return this.props;
    }

    public void releaseExternalActions() {
        Iterator it = this.definitions.values().iterator();
        while (it.hasNext()) {
            ((IPMDRoot)it.next()).clearExternalAction();
        }
    }

    public Collection getNonInstanceCreatingOps(IStaticKey key) throws BPException {
        this.getRootDefinitions();
        Collection ops = (Collection)this.metaNonInstanceCreatingOperations.get(((Object)key).toString());
        if (ops == null) {
            return new ArrayList();
        }
        return ops;
    }

    public void deleteDefinition(String rootKey) throws BPException {
        this.deleteDefinition(new ProcessDefinitionKey(rootKey));
    }

    protected void removeCachedDefinition(String id) {
        this.definitions.remove(id);
    }

    protected void addDefinitionToCache(ProcessDefinitionKey key, IPMDRoot root) {
        this.definitions.put(key, root);
    }

    protected void clearDefinitionCache() {
        this.definitions.clear();
    }

    protected Enumeration getNewDefinitionsCache() {
        return this.newDefinitions.elements();
    }

    protected void clearNewDefinitionsCache() {
        this.newDefinitions.clear();
    }

    protected IPMDRoot getDefinitionFromCache(ProcessDefinitionKey definitionKey) {
        return (IPMDRoot)this.definitions.get(definitionKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public abstract /* synthetic */ void prepare() throws BPException;

    public abstract /* synthetic */ void activateDefinition(String var1) throws BPException;

    public abstract /* synthetic */ void deactivateDefinition(String var1) throws BPException;

    public abstract /* synthetic */ void update() throws BPException;
}

