/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.action.bpel.StartCatchAction;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELLinkedActivity;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELProcessType;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELScope;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELStructuredActivity;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.deployment.bpel.ExtensibilityArtifacts;

class BPELCatch
extends BPELStructuredActivity {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELCatch == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELCatch = BPELCatch.class$("org.apache.ode.bpe.deployment.bpel.BPELCatch")) : class$org$apache$ode$bpe$deployment$bpel$BPELCatch).getName());
    private static final String DEFAULT_NAME = "defaultName";
    private BPELVariable variable;
    private HashMap faultMaps = new HashMap();
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELCatch;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$StartCatchAction;

    BPELCatch(BPELNode previous, BPELSchema tag, BPELAttributes attrs, ExtensibilityArtifacts ea) throws DeploymentException {
        super(previous, tag, attrs, logger);
        this.createProcessSequence(this.getAttributes(), this.getEndProcess());
        this.initVariable(attrs, ea);
    }

    BPELCatch(BPELNode previous, BPELAttributes attrs, ExtensibilityArtifacts ea) throws DeploymentException {
        super(previous, BPELSchema.CATCH, attrs, logger);
        this.createProcessSequence(this.getAttributes(), this.getEndProcess());
        this.initVariable(attrs, ea);
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        this.createProcessSequence(activity.getAttributes(), activity.getStartProcess());
        this.linkProcess(BPELProcessType.START, (BPELLinkedActivity)activity, BPELProcessType.START, true);
        ((BPELLinkedActivity)activity).linkProcess(BPELProcessType.END, this, BPELProcessType.END, false);
    }

    String getName() throws DeploymentException {
        String retVal = null;
        if (this.getAttributes().getFaultName() != null) {
            QName tmp = this.getQName(this.getAttributes().getFaultName());
            retVal = tmp.getNamespaceURI() + ":" + tmp.getLocalPart();
        } else {
            retVal = DEFAULT_NAME;
        }
        return retVal;
    }

    BPELNode pop() throws DeploymentException {
        try {
            IPMDChangeCondition ccB = this.getStartProcess().createChangeCondition("Start Catch: " + this.getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELCatch.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            IPMDAction ss = ccB.createAction("Start Catch: " + this.getName(), (class$org$apache$ode$bpe$action$bpel$StartCatchAction == null ? (class$org$apache$ode$bpe$action$bpel$StartCatchAction = BPELCatch.class$("org.apache.ode.bpe.action.bpel.StartCatchAction")) : class$org$apache$ode$bpe$action$bpel$StartCatchAction).getName());
            if (this.variable != null) {
                ss.addMetadata(StartCatchAction.TO_VARIABLE_KEY, this.variable.createLocator(ss, this, null, BPELInvocationType.UPDATE_OBJECT, true));
                ss.addMetadata(StartCatchAction.FAULT_PART_TYPES, this.faultMaps);
            }
            ((BPELScope)this.m_parserStack).addFaultHandler(this);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getName()}, e);
        }
        return this.m_parserStack;
    }

    BPELVariable getVariable(String varName) throws DeploymentException {
        BPELVariable ret = null;
        ret = this.variable != null && this.variable.getName().equals(varName) ? this.variable : this.m_parserStack.getVariable(varName);
        return ret;
    }

    BPELScopePath getScopePath(BPELScopePath path) {
        path.pushScope(this);
        return this.m_parserStack.getScopePath(path);
    }

    void initVariable(BPELAttributes attrs, ExtensibilityArtifacts artifacts) throws DeploymentException {
        if (attrs.getFaultVariable() == null) {
            return;
        }
        QName fault = this.getQName(attrs.getFaultName());
        this.variable = artifacts.getFaultVariable(fault, attrs.getFaultVariable(), this.faultMaps);
        if (this.variable == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_FAULT_NOTFOUND", new Object[]{this.getProcess().getAttributes().getName(), fault.toString()}, null);
        }
        this.variable.setScope(this);
    }

    String getActivityDescription() {
        return "catch is implemented by: " + (class$org$apache$ode$bpe$action$bpel$StartCatchAction == null ? (class$org$apache$ode$bpe$action$bpel$StartCatchAction = BPELCatch.class$("org.apache.ode.bpe.action.bpel.StartCatchAction")) : class$org$apache$ode$bpe$action$bpel$StartCatchAction).getName() + ". It is an exception thrown by the business process.";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

