/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.action.bpel.UnInitVariableMetaData;
import org.apache.ode.bpe.definition.IPMDAction;
import org.apache.ode.bpe.definition.IPMDChangeCondition;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELCopyType;
import org.apache.ode.bpe.deployment.bpel.BPELExpressionVariable;
import org.apache.ode.bpe.deployment.bpel.BPELFrom;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELTo;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;

class BPELCopy
extends BPELNode {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELCopy == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELCopy = BPELCopy.class$("org.apache.ode.bpe.deployment.bpel.BPELCopy")) : class$org$apache$ode$bpe$deployment$bpel$BPELCopy).getName());
    protected BPELFrom m_from;
    protected BPELTo m_to;
    protected boolean m_hasFromQuery;
    protected boolean m_hasToQuery;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELCopy;
    static /* synthetic */ Class class$org$apache$ode$bpe$condition$DefaultConditional;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$CopyAction;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction;

    BPELCopy(BPELNode node, BPELAttributes attr) {
        super(node, BPELSchema.COPY, attr, logger);
    }

    BPELAttributes getFromAttributes() {
        return this.m_from.getAttributes();
    }

    BPELAttributes getToAttributes() {
        return this.m_to.getAttributes();
    }

    BPELAttributes getCopyAttributes() {
        return this.getAttributes();
    }

    void addActivity(BPELNode activity) throws DeploymentException {
        if (activity instanceof BPELFrom) {
            this.m_from = (BPELFrom)activity;
        }
        if (activity instanceof BPELTo) {
            this.m_to = (BPELTo)activity;
        }
    }

    BPELNode pop() throws DeploymentException {
        IPMDChangeCondition cc = null;
        Iterator itr = this.getStartProcess().getChangeConditions();
        IPMDAction ccact = null;
        try {
            cc = itr.hasNext() ? (IPMDChangeCondition)itr.next() : this.getStartProcess().createChangeCondition("ChangeCondition: " + this.getCopyAttributes().getName(), (class$org$apache$ode$bpe$condition$DefaultConditional == null ? (class$org$apache$ode$bpe$condition$DefaultConditional = BPELCopy.class$("org.apache.ode.bpe.condition.DefaultConditional")) : class$org$apache$ode$bpe$condition$DefaultConditional).getName());
            ccact = cc.createAction("ChangeAction: " + this.getCopyAttributes().getName(), (class$org$apache$ode$bpe$action$bpel$CopyAction == null ? (class$org$apache$ode$bpe$action$bpel$CopyAction = BPELCopy.class$("org.apache.ode.bpe.action.bpel.CopyAction")) : class$org$apache$ode$bpe$action$bpel$CopyAction).getName());
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEACTION", new Object[]{this.getProcess().getAttributes().getName(), this.getCopyAttributes().getName()}, e);
        }
        Properties md = new Properties();
        ((Hashtable)md).put("UNITVAR", new UnInitVariableMetaData("http://schemas.xmlsoap.org/ws/2003/03/business-process/", "uninitializedVariable"));
        switch (BPELCopyType.getCopyType(this.getFromAttributes()).getSwitch()) {
            case 1: {
                this.buildFromVariable(md, ccact);
                break;
            }
            case 3: {
                this.buildExpression(md, ccact);
                break;
            }
            case 2: {
                this.buildFromProperty(md, ccact);
                break;
            }
            case 4: {
                this.buildFromPartnerLink(md, ccact);
                break;
            }
            default: {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_FROM_INVALID", new Object[]{this.getProcess().getAttributes().getName(), ((Hashtable)this.getFromAttributes()).toString()}, null);
            }
        }
        ccact.setMetadata(md);
        return super.pop();
    }

    protected void buildFromVariable(Properties md, IPMDAction ccact) throws DeploymentException {
        BPELVariable var = this.getVariable(this.getFromAttributes().getVariable());
        this.m_hasFromQuery = this.getFromAttributes().getQuery() != null;
        BPELInvocationType fromType = BPELInvocationType.SELECT_NODE;
        if (this.getFromAttributes().getQuery() != null) {
            if (this.isToSimpleType()) {
                fromType = BPELInvocationType.SELECT_VALUE;
            }
        } else if (this.getFromAttributes().getPart() != null) {
            if (var.isPartSimpleType(this.getFromAttributes().getPart())) {
                fromType = BPELInvocationType.SELECT_OBJECT;
            }
        } else if (var.isSimpleType()) {
            fromType = BPELInvocationType.SELECT_OBJECT;
        }
        ((Hashtable)md).put("from_variable", var.createLocator(ccact, this, this.m_from, this.getFromAttributes(), fromType, false));
        this.buildTo(md, ccact, fromType);
    }

    protected void buildToVariable(Properties md, IPMDAction ccact, BPELInvocationType fromType) throws DeploymentException {
        BPELVariable var = this.getVariable(this.getToAttributes().getVariable());
        this.m_hasToQuery = this.getToAttributes().getQuery() != null;
        BPELInvocationType toType = null;
        if (!this.m_hasFromQuery && !this.m_hasToQuery) {
            ccact.setActionClass((class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction == null ? (class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction = BPELCopy.class$("org.apache.ode.bpe.action.bpel.CopyContextNodeAction")) : class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction).getName());
        }
        toType = fromType == BPELInvocationType.SELECT_NODE ? BPELInvocationType.GRAFT_BENEATH_NODE : (this.getToAttributes().getQuery() != null ? BPELInvocationType.UPDATE_VALUE : BPELInvocationType.UPDATE_OBJECT);
        ((Hashtable)md).put("to_variable", var.createLocator(ccact, this, this.m_to, this.getToAttributes(), toType, true));
    }

    private void buildExpression(Properties md, IPMDAction ccact) throws DeploymentException {
        BPELExpressionVariable expVar = new BPELExpressionVariable(this.getFromAttributes().getExpression());
        ((Hashtable)md).put("expression_variable", expVar.createLocator(ccact, this, this.m_from, null, BPELInvocationType.SELECT_VALUE, false));
        this.m_hasFromQuery = true;
        this.buildTo(md, ccact, BPELInvocationType.SELECT_VALUE);
    }

    private void buildToPartnerLink(Properties md, IPMDAction ccact, BPELInvocationType fromType) throws DeploymentException {
        this.m_hasToQuery = false;
        if (!this.m_hasFromQuery && !this.m_hasToQuery) {
            ccact.setActionClass((class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction == null ? (class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction = BPELCopy.class$("org.apache.ode.bpe.action.bpel.CopyContextNodeAction")) : class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction).getName());
        }
        this.createPartnerLinkLocator(ccact, this.getToAttributes(), true);
        ((Hashtable)md).put("to_variable", this.getToAttributes().getPartnerLink());
    }

    private void createPartnerLinkLocator(IPMDLocatorHolder act, BPELAttributes attr, boolean forOutPut) throws DeploymentException {
        try {
            this.createLocator(true, act, attr.getPartnerLink(), "/" + attr.getPartnerLink(), null, null, 0, forOutPut, false);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{"partnerLink:" + attr.getPartnerLink(), "/" + attr.getPartnerLink(), null}, e);
        }
    }

    private void buildFromPartnerLink(Properties md, IPMDAction ccact) throws DeploymentException {
        this.m_hasFromQuery = false;
        BPELInvocationType fromType = BPELInvocationType.SELECT_OBJECT;
        this.createPartnerLinkLocator(ccact, this.getFromAttributes(), false);
        ((Hashtable)md).put("from_variable", this.getFromAttributes().getPartnerLink());
        this.buildTo(md, ccact, fromType);
    }

    private void buildFromProperty(Properties md, IPMDAction ccact) throws DeploymentException {
        BPELVariable var = this.getVariable(this.getFromAttributes().getVariable());
        BPELAttributes attr = this.getPropertyAttributes(this.getQName(this.getFromAttributes().getBPWSProperty()), this.getQName(var.getAttributes().getMessageType()));
        this.m_hasFromQuery = attr.getQuery() != null;
        BPELInvocationType invType = null;
        QName dataType = attr.getDataType();
        invType = BPELVariable.IsSimpleType(dataType) ? (attr.getQuery() != null ? BPELInvocationType.SELECT_VALUE : BPELInvocationType.SELECT_OBJECT) : BPELInvocationType.SELECT_NODE;
        ((Hashtable)md).put("from_variable", var.createLocator(ccact, this, this.m_from, attr, invType, false));
        this.buildTo(md, ccact, invType);
    }

    protected void buildToProperty(Properties md, IPMDAction ccact, BPELInvocationType fromType) throws DeploymentException {
        BPELVariable var = this.getVariable(this.getToAttributes().getVariable());
        BPELAttributes attr = this.getPropertyAttributes(this.getQName(this.getToAttributes().getBPWSProperty()), this.getQName(var.getAttributes().getMessageType()));
        this.m_hasToQuery = attr.getQuery() != null;
        BPELInvocationType toType = null;
        if (!this.m_hasFromQuery && !this.m_hasToQuery) {
            ccact.setActionClass((class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction == null ? (class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction = BPELCopy.class$("org.apache.ode.bpe.action.bpel.CopyContextNodeAction")) : class$org$apache$ode$bpe$action$bpel$CopyContextNodeAction).getName());
        }
        toType = fromType == BPELInvocationType.SELECT_NODE ? BPELInvocationType.GRAFT_BENEATH_NODE : (attr.getQuery() != null ? BPELInvocationType.UPDATE_VALUE : BPELInvocationType.UPDATE_OBJECT);
        ((Hashtable)md).put("to_variable", var.createLocator(ccact, this, this.m_to, attr, toType, true));
    }

    protected void buildTo(Properties md, IPMDAction ccact, BPELInvocationType fromType) throws DeploymentException {
        switch (BPELCopyType.getCopyType(this.getToAttributes()).getSwitch()) {
            case 1: {
                this.buildToVariable(md, ccact, fromType);
                break;
            }
            case 2: {
                this.buildToProperty(md, ccact, fromType);
                break;
            }
            case 4: {
                this.buildToPartnerLink(md, ccact, fromType);
                break;
            }
            default: {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_TO_INVALID", new Object[]{this.getProcess().getAttributes().getName(), ((Hashtable)this.getToAttributes()).toString()}, null);
            }
        }
    }

    private boolean isToSimpleType() throws DeploymentException {
        boolean ret = false;
        switch (BPELCopyType.getCopyType(this.getToAttributes()).getSwitch()) {
            case 1: {
                if (this.getToAttributes().getQuery() != null) break;
                BPELVariable var = this.getVariable(this.getToAttributes().getVariable());
                if (this.getToAttributes().getPart() != null) {
                    ret = var.isPartSimpleType(this.getToAttributes().getPart());
                    break;
                }
                ret = var.isSimpleType();
                break;
            }
            case 2: {
                BPELVariable var = this.getVariable(this.getToAttributes().getVariable());
                BPELAttributes attr = this.getPropertyAttributes(this.getQName(this.getToAttributes().getBPWSProperty()), this.getQName(var.getAttributes().getMessageType()));
                if (attr.getQuery() != null) break;
                QName dataType = attr.getDataType();
                return BPELVariable.IsSimpleType(dataType);
            }
            default: {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_TO_INVALID", new Object[]{((Hashtable)this.getToAttributes()).toString()}, null);
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

