/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.definition.service.DefinitionServiceFactory;
import org.apache.ode.bpe.definition.service.unmanaged.DefinitionServiceProxy;
import org.apache.ode.bpe.deployment.bpel.BPELAssign;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELCase;
import org.apache.ode.bpe.deployment.bpel.BPELCatch;
import org.apache.ode.bpe.deployment.bpel.BPELCatchAll;
import org.apache.ode.bpe.deployment.bpel.BPELCompensate;
import org.apache.ode.bpe.deployment.bpel.BPELCompensationHandler;
import org.apache.ode.bpe.deployment.bpel.BPELCopyValue;
import org.apache.ode.bpe.deployment.bpel.BPELCorrelation;
import org.apache.ode.bpe.deployment.bpel.BPELCorrelationSet;
import org.apache.ode.bpe.deployment.bpel.BPELDefinitionKey;
import org.apache.ode.bpe.deployment.bpel.BPELEmpty;
import org.apache.ode.bpe.deployment.bpel.BPELFlow;
import org.apache.ode.bpe.deployment.bpel.BPELFrom;
import org.apache.ode.bpe.deployment.bpel.BPELGraft;
import org.apache.ode.bpe.deployment.bpel.BPELGraftChildren;
import org.apache.ode.bpe.deployment.bpel.BPELInvoke;
import org.apache.ode.bpe.deployment.bpel.BPELLink;
import org.apache.ode.bpe.deployment.bpel.BPELLinkType;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELOnAlarm;
import org.apache.ode.bpe.deployment.bpel.BPELOnMessage;
import org.apache.ode.bpe.deployment.bpel.BPELOtherwise;
import org.apache.ode.bpe.deployment.bpel.BPELPick;
import org.apache.ode.bpe.deployment.bpel.BPELProcess;
import org.apache.ode.bpe.deployment.bpel.BPELPrune;
import org.apache.ode.bpe.deployment.bpel.BPELReceive;
import org.apache.ode.bpe.deployment.bpel.BPELReply;
import org.apache.ode.bpe.deployment.bpel.BPELSchema;
import org.apache.ode.bpe.deployment.bpel.BPELScope;
import org.apache.ode.bpe.deployment.bpel.BPELSequence;
import org.apache.ode.bpe.deployment.bpel.BPELSwitch;
import org.apache.ode.bpe.deployment.bpel.BPELTerminate;
import org.apache.ode.bpe.deployment.bpel.BPELThrow;
import org.apache.ode.bpe.deployment.bpel.BPELTo;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELWSDLVariable;
import org.apache.ode.bpe.deployment.bpel.BPELWait;
import org.apache.ode.bpe.deployment.bpel.BPELWhile;
import org.apache.ode.bpe.deployment.bpel.BPELXMLSchemaVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.deployment.bpel.ExtensibilityArtifacts;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.UUIDService;
import org.apache.ode.bpe.uuid.UUIDServiceException;
import org.apache.ode.bpe.uuid.UUIDServiceFactory;

class BPELRepositoryHandler {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELRepositoryHandler == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELRepositoryHandler = BPELRepositoryHandler.class$("org.apache.ode.bpe.deployment.bpel.BPELRepositoryHandler")) : class$org$apache$ode$bpe$deployment$bpel$BPELRepositoryHandler).getName());
    private DefinitionService m_ds;
    private BPEProperties m_props;
    private String m_bpelName;
    private BPELNode m_context;
    private BPELDefinitionKey m_defKey;
    private IPMDRoot m_dRoot;
    private ExtensibilityArtifacts m_artifacts;
    private boolean m_insidePruneAssign = false;
    private boolean m_insideGraftAssign = false;
    private boolean m_insideGraftChildrenAssign = false;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELRepositoryHandler;

    BPELRepositoryHandler(String docName, HashMap supportDoc, DefinitionService ds) throws DeploymentException {
        this.m_bpelName = docName;
        try {
            if (ds == null) {
                this.m_props = new BPEProperties();
                this.m_props.setDefinitionServiceClass("org.apache.ode.bpe.definition.serialimpl.DefinitionService_SerImpl");
                UUIDService us = UUIDServiceFactory.createUUIDService(this.m_props);
                this.m_ds = DefinitionServiceFactory.createDefinitionService(this.m_props, us);
            } else {
                this.m_ds = ds;
                this.m_props = ds.getBPEProperties();
            }
            this.m_artifacts = new ExtensibilityArtifacts(docName, supportDoc, this.m_props);
        }
        catch (UUIDServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_UUIDINVALID", null, e);
        }
        catch (DefinitionServiceException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_DEFINVALID", null, e);
        }
    }

    public void buildPruneAssign(BPELAttributes attributes) throws DeploymentException {
        this.m_insidePruneAssign = true;
        this.buildAssign(attributes);
    }

    public void buildGraftAssign(BPELAttributes attributes) throws DeploymentException {
        this.m_insideGraftAssign = true;
        this.buildAssign(attributes);
    }

    public void buildGraftChildrenAssign(BPELAttributes attributes) throws DeploymentException {
        this.m_insideGraftChildrenAssign = true;
        this.buildAssign(attributes);
    }

    public String getInterpretation(String activityID) {
        if (this.m_artifacts != null) {
            return this.m_artifacts.getActivityInterpretation(activityID);
        }
        return null;
    }

    public void buildProcess(BPELAttributes attr) throws DeploymentException {
        IPMDProcess bProcess = null;
        try {
            this.m_dRoot = this.m_ds.createRootDefinition(attr.getName() == null ? "process" : attr.getName(), "v1", false);
            bProcess = this.m_dRoot.createProcess("Process: " + attr.getName());
            this.m_defKey = new BPELDefinitionKey(attr.getName(), bProcess.getKey().getValue());
        }
        catch (BPException e) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATEPROCESSROOT", new Object[]{this.m_bpelName, attr.getName()}, e);
        }
        this.push(new BPELProcess(this.m_dRoot, bProcess, attr, this.m_artifacts));
    }

    public void closeProcess() throws DeploymentException {
        if (this.m_context instanceof BPELScope) {
            this.pop();
        }
        this.m_dRoot.setIsStateless(((BPELProcess)this.m_context).getStateFlag());
        this.m_dRoot.setProtectedInstantiation(((BPELProcess)this.m_context).getIsProtectedInstantiation());
        this.pop();
        if (this.m_ds instanceof DefinitionServiceProxy) {
            try {
                ((DefinitionServiceProxy)this.m_ds).update();
            }
            catch (DefinitionServiceException e) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_UPDATE", new Object[]{this.m_bpelName}, e);
            }
        }
    }

    public void buildCatch(BPELAttributes attr) throws DeploymentException {
        this.testInvoke();
        this.push(new BPELCatch(this.m_context, attr, this.m_artifacts));
    }

    public void closeCatch() throws DeploymentException {
        this.pop();
    }

    public void buildCatchAll(BPELAttributes attr) throws DeploymentException {
        this.testInvoke();
        this.push(new BPELCatchAll(this.m_context, attr, this.m_artifacts));
    }

    public void closeCatchAll() throws DeploymentException {
        this.pop();
    }

    public void buildCompensationHandler(BPELAttributes attr) throws DeploymentException {
        this.testInvoke();
        this.push(new BPELCompensationHandler(this.m_context, attr));
    }

    public void closeCompensationHandler() throws DeploymentException {
        this.pop();
    }

    public void buildOnMessage(BPELAttributes attr) throws DeploymentException {
        if (this.m_context instanceof BPELPick) {
            this.push(new BPELOnMessage(this.m_context, attr));
        } else {
            this.testScope();
            this.push(new BPELOnMessage(this.m_context, attr));
        }
    }

    public void closeOnMessage() throws DeploymentException {
        this.pop();
    }

    public void buildOnAlarm(BPELAttributes attr) throws DeploymentException {
        if (this.m_context instanceof BPELPick) {
            this.push(new BPELOnAlarm(this.m_context, attr));
        } else {
            this.testScope();
            this.push(new BPELOnAlarm(this.m_context, attr));
        }
    }

    public void closeOnAlarm() throws DeploymentException {
        this.pop();
    }

    public void buildData(String data) {
        this.m_context.addData(data);
    }

    public void buildSwitch(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELSwitch(this.m_context, attr));
    }

    public void closeSwitch() throws DeploymentException {
        this.pop();
    }

    public void buildOtherwise(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELOtherwise(this.m_context, attr));
    }

    public void closeOtherwise() throws DeploymentException {
        this.pop();
    }

    public void buildCase(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELCase(this.m_context, attr));
    }

    public void closeCase() throws DeploymentException {
        this.pop();
    }

    public void buildWhile(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELWhile(this.m_context, attr));
    }

    public void closeWhile() throws DeploymentException {
        this.pop();
    }

    public void buildScope(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELScope(this.m_context, attr));
    }

    public void closeScope() throws DeploymentException {
        this.pop();
    }

    public void buildFlow(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELFlow(this.m_context, attr));
    }

    public void closeFlow() throws DeploymentException {
        this.pop();
    }

    public void buildPick(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELPick(this.m_context, attr));
    }

    public void closePick() throws DeploymentException {
        this.pop();
    }

    public void buildVariable(BPELAttributes attr) throws DeploymentException {
        this.testScope();
        if (attr.getMessageType() != null) {
            ((BPELScope)this.m_context).addVariable(new BPELWSDLVariable(attr, this.m_artifacts, this.m_context));
        } else {
            ((BPELScope)this.m_context).addVariable(new BPELXMLSchemaVariable(attr, this.m_artifacts, this.m_context));
        }
    }

    public void buildCorrelationSet(BPELAttributes attr) throws DeploymentException {
        this.testScope();
        ((BPELScope)this.m_context).addCorrelationSet(new BPELCorrelationSet(attr, (BPELScope)this.m_context));
    }

    public void buildCorrelation(BPELAttributes attr) throws DeploymentException {
        BPELCorrelationSet cs = this.m_context.getCorrelationSet(attr.getSet());
        if (cs == null) {
            BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CORRSET", new Object[]{this.m_bpelName, attr.getSet()}, null);
        }
        this.m_context.addCorrelation(new BPELCorrelation(cs, attr.getInitiate(), attr.getPattern()));
    }

    public void buildPartners(BPELAttributes attr) {
    }

    public void buildLink(BPELAttributes attr) throws DeploymentException {
        ((BPELFlow)this.m_context).addLinkTag(new BPELLink(attr.getName()));
    }

    public void buildSequence(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELSequence(this.m_context, attr));
    }

    public void closeSequence() throws DeploymentException {
        this.pop();
    }

    public void buildSource(BPELAttributes attr) throws DeploymentException {
        this.m_context.setLink(attr.getLinkName(), this.m_context, BPELLinkType.SOURCE, attr.getTransitionCondition());
    }

    public void buildTarget(BPELAttributes attr) throws DeploymentException {
        this.m_context.setLink(attr.getLinkName(), this.m_context, BPELLinkType.TARGET, null);
    }

    public void buildInvoke(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELInvoke(this.m_context, attr, this.m_artifacts));
    }

    public void closeInvoke() throws DeploymentException {
        this.pop();
    }

    public void buildFrom(BPELAttributes attr) {
        this.push(new BPELFrom(this.m_context, attr));
    }

    public void closeFrom() throws DeploymentException {
        this.pop();
    }

    public void buildTo(BPELAttributes attr) {
        this.push(new BPELTo(this.m_context, attr));
    }

    public void closeTo() throws DeploymentException {
        this.pop();
    }

    public void buildCopy(BPELAttributes attr) {
        if (this.m_insidePruneAssign) {
            this.push(new BPELPrune(this.m_context, attr));
        } else if (this.m_insideGraftAssign) {
            this.push(new BPELGraft(this.m_context, attr));
        } else if (this.m_insideGraftChildrenAssign) {
            this.push(new BPELGraftChildren(this.m_context, attr));
        } else {
            this.push(new BPELCopyValue(this.m_context, attr));
        }
    }

    public void closeCopy() throws DeploymentException {
        if (this.m_insidePruneAssign) {
            this.closePrune();
        } else {
            this.pop();
        }
    }

    public void buildPrune(BPELAttributes attr) {
        this.push(new BPELPrune(this.m_context, attr));
    }

    public void closePrune() throws DeploymentException {
        this.pop();
    }

    public void buildAssign(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELAssign(this.m_context, BPELSchema.ASSIGN, attr, logger));
    }

    public void closeAssign() throws DeploymentException {
        this.pop();
        if (this.m_insidePruneAssign) {
            this.m_insidePruneAssign = false;
        }
        if (this.m_insideGraftAssign) {
            this.m_insideGraftAssign = false;
        }
        if (this.m_insideGraftChildrenAssign) {
            this.m_insideGraftChildrenAssign = false;
        }
    }

    public void buildReceive(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELReceive(this.m_context, attr));
    }

    public void closeReceive() throws DeploymentException {
        this.pop();
    }

    public void buildReply(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELReply(this.m_context, attr));
    }

    public void closeReply() throws DeploymentException {
        this.pop();
    }

    public void buildCompensate(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELCompensate(this.m_context, attr));
    }

    public void closeCompensate() throws DeploymentException {
        this.pop();
    }

    public void buildThrow(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELThrow(this.m_context, attr));
    }

    public void closeThrow() throws DeploymentException {
        this.pop();
    }

    public void buildTerminate(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELTerminate(this.m_context, attr));
    }

    public void closeTerminate() throws DeploymentException {
        this.pop();
    }

    public void buildEmpty(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELEmpty(this.m_context, attr));
    }

    public void closeEmpty() throws DeploymentException {
        this.pop();
    }

    public void buildWait(BPELAttributes attr) throws DeploymentException {
        this.push(new BPELWait(this.m_context, attr));
    }

    public void closeWait() throws DeploymentException {
        this.pop();
    }

    private void testScope() throws DeploymentException {
        if (!(this.m_context instanceof BPELScope)) {
            this.buildScope(new BPELAttributes());
        }
    }

    private void testInvoke() throws DeploymentException {
        if (!(this.m_context instanceof BPELScope)) {
            if (this.m_context instanceof BPELInvoke) {
                BPELNode parentContext = this.m_context.m_parserStack;
                if (parentContext instanceof BPELScope) {
                    this.m_context = this.m_context.pop();
                } else {
                    BPELNode currentInvoke = this.m_context;
                    currentInvoke.m_parserStack = this.m_context = new BPELScope(parentContext, new BPELAttributes());
                    currentInvoke.pop();
                }
            } else {
                this.buildScope(new BPELAttributes());
            }
        }
    }

    private void pop() throws DeploymentException {
        this.m_context = this.m_context.pop();
    }

    private void push(BPELNode node) {
        this.m_context = node;
    }

    BPELDefinitionKey getDefKey() {
        return this.m_defKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

