/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.definition.service.DefinitionServiceException;
import org.apache.ode.bpe.deployment.bpel.BPELAttributes;
import org.apache.ode.bpe.deployment.bpel.BPELInvocationType;
import org.apache.ode.bpe.deployment.bpel.BPELNode;
import org.apache.ode.bpe.deployment.bpel.BPELScopePath;
import org.apache.ode.bpe.deployment.bpel.BPELUtil;
import org.apache.ode.bpe.deployment.bpel.BPELVariable;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.deployment.bpel.ExtensibilityArtifacts;

class BPELWSDLVariable
extends BPELVariable {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELWSDLVariable == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELWSDLVariable = BPELWSDLVariable.class$("org.apache.ode.bpe.deployment.bpel.BPELWSDLVariable")) : class$org$apache$ode$bpe$deployment$bpel$BPELWSDLVariable).getName());
    private Message msg;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELWSDLVariable;

    BPELWSDLVariable(BPELAttributes attrs, HashMap containerMap, Message msg) throws DeploymentException {
        super(attrs, containerMap, logger);
        this.msg = msg;
    }

    BPELWSDLVariable(BPELAttributes attrs, ExtensibilityArtifacts ea, BPELNode node) throws DeploymentException {
        super(attrs, ea.getContainerMap(attrs.getName()), logger);
        if (attrs.getMessageType() != null) {
            this.msg = ea.getMessage(attrs.getMessageType(), node);
            if (this.msg == null) {
                BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_MSG_NOTFOUND", new Object[]{node.getProcess().getAttributes().getName(), attrs.getMessageType()}, null);
            }
        } else {
            BPELUtil.throwNewException(logger, Level.SEVERE, "DEPLOY_UNKNOWN_VARTYPE", null, null);
        }
    }

    Object createLocator(IPMDLocatorHolder locator, BPELNode node, BPELNode tagNode, BPELAttributes attrs, BPELInvocationType type, boolean forOutPut) throws DeploymentException {
        this.addUsedInActivity(node);
        String locatorName = null;
        IPMDLocator loc = null;
        boolean inCompHandler = node.inCompensationHandler();
        String partName = attrs != null ? attrs.getPart() : null;
        String query = attrs != null ? attrs.getQuery() : null;
        locatorName = attrs != null && attrs.getName() != null ? attrs.getName() : this.getName() + ":" + partName;
        String processName = node.getProcess().getAttributes().getName();
        query = this.parseBpelFunctionCalls(query);
        if (partName != null) {
            loc = locator.getLocator(locatorName);
            if (loc == null) {
                try {
                    loc = node.createLocator(true, locator, locatorName, this.getScopePath(new BPELScopePath(inCompHandler)).toString() + "/" + this.getName() + "/" + partName, this.getInvocation(query, tagNode, type, this.getInvFactory(processName, partName)), this.getIntBuilder(processName, partName), 0, forOutPut, false);
                }
                catch (DefinitionServiceException e) {
                    BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{processName, locatorName, this.getScopePath(new BPELScopePath(inCompHandler)).toString() + "/" + this.getName() + "/" + partName, query}, e);
                }
            } else {
                loc.setForOutput(forOutPut);
            }
            this.addUsedInLocator(loc);
        } else {
            Iterator itr = this.msg.getParts().values().iterator();
            while (itr.hasNext()) {
                Part p = (Part)itr.next();
                locatorName = this.getName() + ":" + p.getName();
                loc = locator.getLocator(locatorName);
                if (loc == null) {
                    try {
                        loc = node.createLocator(true, locator, locatorName, this.getScopePath(new BPELScopePath(inCompHandler)).toString() + "/" + this.getName() + "/" + p.getName(), this.getInvocation(query, node, type, this.getInvFactory(processName, p.getName())), this.getIntBuilder(processName, p.getName()), 0, forOutPut, false);
                    }
                    catch (DefinitionServiceException e) {
                        BPELUtil.throwNewException(logger, Level.SEVERE, "BPEL_CREATELOCATOR", new Object[]{node.getProcess().getAttributes().getName(), locatorName, this.getScopePath(new BPELScopePath(inCompHandler)).toString() + "/" + this.getName() + "/" + partName, query}, e);
                    }
                } else {
                    loc.setForOutput(forOutPut);
                }
                this.addUsedInLocator(loc);
            }
            locatorName = this.getName();
        }
        this.handleNestedVariables(node, tagNode, locator, type);
        return locatorName;
    }

    QName getMessageName() {
        return this.msg.getQName();
    }

    boolean isPartSimpleType(String partName) {
        Part msgPart = this.msg.getPart(partName);
        if (msgPart == null) {
            return false;
        }
        QName type = msgPart.getTypeName();
        if (type == null) {
            type = msgPart.getElementName();
        }
        return BPELVariable.IsSimpleType(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

