/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.XMLInteractionObject;
import org.apache.ode.bpe.util.XMLDocBuilderByThread;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PropertiesInteractionObject
extends XMLInteractionObject {
    static final long serialVersionUID = 1522517564037436979L;
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$interaction$PropertiesInteractionObject == null ? (class$org$apache$ode$bpe$interaction$PropertiesInteractionObject = PropertiesInteractionObject.class$("org.apache.ode.bpe.interaction.PropertiesInteractionObject")) : class$org$apache$ode$bpe$interaction$PropertiesInteractionObject).getName());
    private transient Properties m_properties = null;
    private static final String PROPERTIES_ROOT = "Properties";
    private static final String PROPERTY_ELEMENT = "Property";
    private static final String NAME_ELEMENT = "name";
    private static final String VALUE_ELEMENT = "value";
    static /* synthetic */ Class class$org$apache$ode$bpe$interaction$PropertiesInteractionObject;

    protected PropertiesInteractionObject() {
    }

    public PropertiesInteractionObject(Properties iProperties) throws InteractionException {
        try {
            this.m_properties = iProperties;
            Document document = this.createDocumentFromProperties(iProperties);
            this.setDocument(document);
        }
        catch (Exception e) {
            InteractionException bpx = new InteractionException("NATIVE_EXCEPTION", new Object[]{"Exception"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
    }

    private Document createDocumentFromProperties(Properties iProperties) throws Exception {
        Document document = XMLDocBuilderByThread.getDocBuilder().newDocument();
        Element propertiesRoot = document.createElement(PROPERTIES_ROOT);
        document.appendChild(propertiesRoot);
        Enumeration<?> names = iProperties.propertyNames();
        while (names.hasMoreElements()) {
            String nextName = (String)names.nextElement();
            String nextValue = iProperties.getProperty(nextName);
            Element newProperty = document.createElement(PROPERTY_ELEMENT);
            Element newName = document.createElement(NAME_ELEMENT);
            Element newValue = document.createElement(VALUE_ELEMENT);
            Text newNameTextNode = document.createTextNode(nextName);
            Text newValueTextNode = document.createTextNode(nextValue);
            newName.appendChild(newNameTextNode);
            newValue.appendChild(newValueTextNode);
            newProperty.appendChild(newName);
            newProperty.appendChild(newValue);
            propertiesRoot.appendChild(newProperty);
        }
        return document;
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

