/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IAccessControl;
import org.apache.ode.bpe.context.ICloneable;
import org.apache.ode.bpe.interaction.BufferInteraction;
import org.apache.ode.bpe.interaction.IDocumentAccessible;
import org.apache.ode.bpe.interaction.IDocumentMutable;
import org.apache.ode.bpe.interaction.IObjectAccessible;
import org.apache.ode.bpe.interaction.IObjectMutable;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.InvalidTypeException;
import org.apache.ode.bpe.util.XMLDocBuilderByThread;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XMLInteractionObject
extends BufferInteraction
implements IAccessControl,
ICloneable,
IDocumentAccessible,
IDocumentMutable,
Serializable,
IObjectAccessible,
IObjectMutable {
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$interaction$XMLInteractionObject == null ? (class$org$apache$ode$bpe$interaction$XMLInteractionObject = XMLInteractionObject.class$("org.apache.ode.bpe.interaction.XMLInteractionObject")) : class$org$apache$ode$bpe$interaction$XMLInteractionObject).getName());
    private static final long serialVersionUID = 1L;
    private transient Document m_document;
    private transient Serializer m_serializer;
    static /* synthetic */ Class class$org$apache$ode$bpe$interaction$XMLInteractionObject;

    public void setDocument(Document iDocument) {
        this.clearBuffer();
        this.setDirty(true);
        this.m_document = iDocument;
    }

    public void setEmptyDocument() throws InteractionException {
        Document document;
        try {
            document = XMLDocBuilderByThread.getDocBuilder().newDocument();
        }
        catch (Exception e) {
            InteractionException bpx = new InteractionException("NATIVE_EXCEPTION", new Object[]{"Exception"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        this.setDocument(document);
    }

    protected void clearDocument() {
        this.m_document = null;
    }

    public void setBuffer(byte[] iBuffer) {
        this.clearDocument();
        super.setBuffer(iBuffer);
    }

    public byte[] getXMLBuffer() throws IOException {
        if (this.getDirty()) {
            this.serializeDocument();
            this.setDirty(false);
        }
        return this.getBuffer();
    }

    public String toString() {
        try {
            this.serializeDocument();
            if (this.getBuffer() == null) {
                return null;
            }
            return new String(this.getBuffer());
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    public Document getDocument() throws Exception {
        if (this.m_document == null && this.getBuffer() == null) {
            this.setEmptyDocument();
        }
        if (this.m_document == null) {
            ByteArrayInputStream bai = new ByteArrayInputStream(this.getBuffer());
            InputSource in = new InputSource(bai);
            this.m_document = XMLDocBuilderByThread.getDocBuilder().parse(in);
        }
        return this.m_document;
    }

    public Object cloneObject() {
        XMLInteractionObject newObject = new XMLInteractionObject();
        try {
            this.serializeDocument();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        newObject.setBuffer(super.cloneBuffer());
        return newObject;
    }

    public void releaseResources() throws InteractionException {
    }

    private void serializeDocument() throws IOException {
        if (this.getBuffer() == null || this.getDirty()) {
            if (this.m_document != null && this.m_document.hasChildNodes()) {
                if (this.m_serializer == null) {
                    Properties props = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
                    this.m_serializer = SerializerFactory.getSerializer((Properties)props);
                }
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                this.m_serializer.setOutputStream((OutputStream)bao);
                this.m_serializer.asDOMSerializer().serialize((Node)this.m_document);
                super.setBuffer(bao.toByteArray());
                this.m_serializer.reset();
                this.setDirty(false);
            } else {
                this.setBuffer(null);
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        this.serializeDocument();
        byte[] buffer = this.getBuffer();
        if (buffer != null) {
            int length = buffer.length;
            s.writeInt(length);
            s.write(buffer);
        } else {
            s.writeInt(-1);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int length = s.readInt();
        if (length != -1) {
            byte[] buffer = new byte[length];
            s.readFully(buffer);
            this.setBuffer(buffer);
        }
    }

    public Object getObject(String iPreference) throws InteractionException {
        try {
            if (iPreference == null || iPreference.equals("interaction")) {
                return this;
            }
            if (iPreference.equals("buf") || iPreference.equals("[B") || iPreference.equals("byte[]")) {
                return this.getXMLBuffer();
            }
            return this.getDocument();
        }
        catch (Exception e) {
            throw new InteractionException(null, null, e);
        }
    }

    public Object getObject() throws InteractionException {
        return this.getObject("");
    }

    public void setObject(Object iObject) throws InteractionException {
        if (iObject instanceof byte[]) {
            this.setBuffer((byte[])iObject);
        } else if (iObject instanceof Document) {
            this.setDocument((Document)iObject);
        } else {
            throw new InvalidTypeException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

