/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.spiimpl;

import java.util.Iterator;
import java.util.LinkedList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteraction;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteractionFactory;
import org.apache.ode.bpe.util.BPEProperties;

public class MasterInteractionFactory
implements ISPIInteractionFactory {
    static final long serialVersionUID = 3229334691771274257L;
    private LinkedList m_factoryList = new LinkedList();
    private static MasterInteractionFactory MasterInstance = null;

    private MasterInteractionFactory() {
        BPEProperties props;
        try {
            props = new BPEProperties(true, new InitialContext());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        String factoriesString = props.getInteractionFactories();
        String externalFactoriesString = props.getExternalInteractionFactories();
        this.addInteractionFactories(externalFactoriesString);
        this.addInteractionFactories(factoriesString);
    }

    private void addInteractionFactories(String factoriesString) {
        if (factoriesString == null || factoriesString.equals("")) {
            return;
        }
        String[] factories = factoriesString.split(",");
        for (int i = 0; i < factories.length; ++i) {
            ISPIInteractionFactory factory;
            try {
                factory = (ISPIInteractionFactory)Class.forName(factories[i]).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.m_factoryList.add(factory);
        }
    }

    private static synchronized ISPIInteractionFactory CreateMasterInstance() {
        if (MasterInstance == null) {
            MasterInstance = new MasterInteractionFactory();
        }
        return MasterInstance;
    }

    public ISPIInteraction createAnyTypeInteraction() {
        Iterator iter = this.m_factoryList.iterator();
        while (iter.hasNext()) {
            ISPIInteractionFactory f = (ISPIInteractionFactory)iter.next();
            if (!f.supportsAnyType()) continue;
            return f.createAnyTypeInteraction();
        }
        throw new UnsupportedOperationException();
    }

    public ISPIInteraction createInteraction(IDescribedValue describedValue) {
        Iterator iter = this.m_factoryList.iterator();
        ISPIInteractionFactory f = null;
        while (iter.hasNext()) {
            f = (ISPIInteractionFactory)iter.next();
            if (!f.supportsInteraction(describedValue)) continue;
            return f.createInteraction(describedValue);
        }
        throw new UnsupportedOperationException();
    }

    public boolean supportsInteraction(IDescribedValue describedValue) {
        Iterator iter = this.m_factoryList.iterator();
        while (iter.hasNext()) {
            ISPIInteractionFactory f = (ISPIInteractionFactory)iter.next();
            if (!f.supportsInteraction(describedValue)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsAnyType() {
        Iterator iter = this.m_factoryList.iterator();
        while (iter.hasNext()) {
            ISPIInteractionFactory f = (ISPIInteractionFactory)iter.next();
            if (!f.supportsAnyType()) continue;
            return true;
        }
        return false;
    }

    public static ISPIInteractionFactory newInstance() {
        if (MasterInstance == null) {
            return MasterInteractionFactory.CreateMasterInstance();
        }
        return MasterInstance;
    }
}

