/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.spiimpl.atomic;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LazyObject
implements Serializable {
    static final long serialVersionUID = -2181661690231270298L;
    private transient Object rawObject;
    private String xmlString;

    public LazyObject(Object rawObject) {
        this.rawObject = rawObject;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.xmlString == null && this.rawObject != null) {
            XStream xstream = new XStream();
            this.xmlString = xstream.toXML(this.rawObject);
        }
        s.defaultWriteObject();
    }

    public Object getObject() {
        if (this.rawObject == null && this.xmlString != null) {
            XStream xstream = new XStream();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            xstream.setClassLoader(contextClassLoader);
            this.rawObject = xstream.fromXML(this.xmlString);
        }
        return this.rawObject;
    }
}

