/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.spiimpl.document;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import org.apache.ode.bpe.interaction.IDocumentAccessible;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.util.XMLDocBuilderByThread;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.Serializer;
import org.apache.xml.serializer.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class LazyDocument
implements Serializable,
IDocumentAccessible {
    static final long serialVersionUID = -279092603880466152L;
    private transient Document m_document;
    private transient boolean m_dirty;
    private transient Serializer m_serializer;
    private byte[] m_xmlbuffer = new byte[0];

    public LazyDocument() {
    }

    public LazyDocument(byte[] xmlbytes) {
        this.m_xmlbuffer = xmlbytes;
    }

    protected void setEmptyDocument() {
        this.m_document = this.getDocBuilder().newDocument();
    }

    protected DocumentBuilder getDocBuilder() {
        try {
            return XMLDocBuilderByThread.getDocBuilder();
        }
        catch (InteractionException e) {
            throw new RuntimeException(e);
        }
    }

    public LazyDocument(Document iDocument) {
        this.m_document = iDocument;
    }

    public Document getDocument() {
        if (this.m_document == null) {
            this.deserializeDocument();
        }
        return this.m_document;
    }

    private void deserializeDocument() {
        try {
            if (this.m_xmlbuffer.length > 0) {
                ByteArrayInputStream bai = new ByteArrayInputStream(this.m_xmlbuffer);
                InputSource in = new InputSource(bai);
                this.m_document = XMLDocBuilderByThread.getDocBuilder().parse(in);
            } else {
                this.setEmptyDocument();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.serializeDocument();
        s.defaultWriteObject();
    }

    public void setDirty(boolean dirty) {
        this.m_dirty = dirty;
    }

    public byte[] getXMLBuffer() {
        try {
            this.serializeDocument();
        }
        catch (IOException e) {
            throw new UnsupportedOperationException(e.toString());
        }
        return this.m_xmlbuffer;
    }

    private void serializeDocument() throws IOException {
        if (this.m_xmlbuffer.length == 0 || this.m_dirty) {
            if (this.m_document != null && this.m_document.hasChildNodes()) {
                if (this.m_serializer == null) {
                    Properties props = OutputPropertiesFactory.getDefaultMethodProperties((String)"xml");
                    this.m_serializer = SerializerFactory.getSerializer((Properties)props);
                }
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                this.m_serializer.setOutputStream((OutputStream)bao);
                this.m_serializer.asDOMSerializer().serialize((Node)this.m_document);
                this.m_xmlbuffer = bao.toByteArray();
                this.setDirty(false);
            } else {
                this.m_xmlbuffer = new byte[0];
            }
        }
    }

    public Object getConvenientForm() {
        if (this.m_dirty) {
            return this.getDocument();
        }
        return this.getXMLBuffer();
    }
}

