/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.scope.service;

import java.util.HashMap;
import org.apache.ode.bpe.action.internal.ActionException;

public class BPRuntimeException
extends ActionException {
    static final long serialVersionUID = -3191176170122334709L;
    private String faultName;
    private String faultType;
    private String nameSpace;
    private HashMap errorMessage = new HashMap();

    public BPRuntimeException(String name, String detailMessage) {
        super(detailMessage);
        this.faultName = name;
    }

    public BPRuntimeException(String name, Throwable cause) {
        super(cause);
        this.faultName = name;
    }

    public BPRuntimeException(String name, String message_id, Object[] msgParams) {
        super(message_id, msgParams);
        this.faultName = name;
    }

    public BPRuntimeException(String name, String message_id, Object[] msgParams, Throwable cause) {
        super(message_id, msgParams, cause);
        this.faultName = name;
    }

    public String getBPException() {
        String retVal = this.faultName;
        if (this.nameSpace != null) {
            retVal = this.nameSpace + ":" + this.faultName;
        }
        return retVal;
    }

    public void addPartMessage(String partName, Object msg) {
        this.errorMessage.put(partName, msg);
    }

    public Object getPartMessage(String partName) {
        return this.errorMessage.get(partName);
    }

    public HashMap getMessageParts() {
        return this.errorMessage;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String getName() {
        return this.faultName;
    }

    public String getType() {
        return this.faultType;
    }

    public String toString() {
        return "BPRuntimeException(nameSpace:" + this.nameSpace + " faultName:" + this.faultName + " fualtType:" + this.faultType + ")";
    }
}

