/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.uuid;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;
import org.apache.ode.bpe.uuid.ConnectorUUIDService;
import org.apache.ode.bpe.uuid.UUIDService;
import org.apache.ode.bpe.uuid.UUIDServiceException;

public class UUIDServiceFactory {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$uuid$UUIDServiceFactory == null ? (class$org$apache$ode$bpe$uuid$UUIDServiceFactory = UUIDServiceFactory.class$("org.apache.ode.bpe.uuid.UUIDServiceFactory")) : class$org$apache$ode$bpe$uuid$UUIDServiceFactory).getName());
    private static String IM_UUID_PROPERTY_FILE_NAME = "theUUIDService.properties";
    static /* synthetic */ Class class$org$apache$ode$bpe$uuid$UUIDServiceFactory;

    public static UUIDService createUUIDService(BPEProperties props) throws UUIDServiceException {
        UUIDService uuidService;
        if (props.getUUIDUseConnector()) {
            uuidService = new ConnectorUUIDService();
            uuidService.init(props);
        } else {
            try {
                Class<?> uuidClass = Class.forName(props.getUUIDServiceClass());
                uuidService = (UUIDService)uuidClass.newInstance();
                uuidService.init(props);
            }
            catch (ClassNotFoundException e) {
                UUIDServiceException use = new UUIDServiceException("CLASS_NOT_FOUND", new Object[]{props.getEventDirectorClass()});
                use.log(logger, Level.SEVERE);
                throw use;
            }
            catch (InstantiationException e) {
                UUIDServiceException use = new UUIDServiceException("NATIVE_EXCEPTION", new Object[]{"InstantiationException"}, e);
                use.log(logger, Level.SEVERE);
                throw use;
            }
            catch (IllegalAccessException e) {
                UUIDServiceException use = new UUIDServiceException("NATIVE_EXCEPTION", new Object[]{"IllegalAccessException"}, e);
                use.log(logger, Level.SEVERE);
                throw use;
            }
            catch (BPException e) {
                throw new UUIDServiceException("BPE_EXCEPTION", new Object[0], e);
            }
        }
        return uuidService;
    }

    public static UUIDService createUUIDService() throws UUIDServiceException {
        BPEProperties props = new BPEProperties();
        try {
            File file = new File(IM_UUID_PROPERTY_FILE_NAME);
            if (file.exists()) {
                FileInputStream ifstrm = new FileInputStream(IM_UUID_PROPERTY_FILE_NAME);
                props.load(ifstrm);
            }
        }
        catch (IOException e) {
            UUIDServiceException se = new UUIDServiceException("NATIVE_EXCEPTION", new Object[]{"IOException"}, e);
            se.log(logger, Level.SEVERE);
            throw se;
        }
        return UUIDServiceFactory.createUUIDService(props);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

