/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.uuid.connector;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ManagedConnection;

public class UUIDEventListener {
    private Vector listeners = new Vector();
    private ManagedConnection mc;

    UUIDEventListener(ManagedConnection mc) {
        this.mc = mc;
    }

    void sendEvent(int eventType, Exception ex, Object connectionHandle) {
        Vector list = new Vector(this.listeners);
        ConnectionEvent ce = null;
        ce = ex == null ? new ConnectionEvent(this.mc, eventType) : new ConnectionEvent(this.mc, eventType, ex);
        if (connectionHandle != null) {
            ce.setConnectionHandle(connectionHandle);
        }
        Iterator iter = ((AbstractList)list).iterator();
        block7: while (iter.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iter.next();
            switch (eventType) {
                case 1: {
                    l.connectionClosed(ce);
                    continue block7;
                }
                case 2: {
                    l.localTransactionStarted(ce);
                    continue block7;
                }
                case 3: {
                    l.localTransactionCommitted(ce);
                    continue block7;
                }
                case 4: {
                    l.localTransactionRolledback(ce);
                    continue block7;
                }
                case 5: {
                    l.connectionErrorOccurred(ce);
                    continue block7;
                }
            }
            throw new IllegalArgumentException("Illegal eventType: " + eventType);
        }
    }

    void addConnectorListener(ConnectionEventListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.addElement(l);
        }
    }

    void removeConnectorListener(ConnectionEventListener l) {
        this.listeners.removeElement(l);
    }
}

