/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.util.BPException;

public class EndScopeAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$EndScopeAction == null ? (class$org$apache$ode$bpe$action$bpel$EndScopeAction = EndScopeAction.class$("org.apache.ode.bpe.action.bpel.EndScopeAction")) : class$org$apache$ode$bpe$action$bpel$EndScopeAction).getName());
    public static final String COMP_HANLDER = "compHandler";
    public static final String LOCATORS = "end_scope_locators";
    private Properties props;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$EndScopeAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        IScopeService ss = resolver.getScopeService();
        IFCScopeInstance scope = ss.getScope(processInstance.getScopePath());
        String compHandler = this.props.getProperty(COMP_HANLDER);
        if (compHandler != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Installing compensation handler:" + compHandler);
            }
            List locators = (List)((Hashtable)this.props).get(LOCATORS);
            scope.setCompensationHandler(compHandler, locators, resolver, processInstance.getKey());
        }
        scope.setInactive(processInstance, ec, pcb);
        ScopePath sp = processInstance.getScopePath();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Changing scope from " + processInstance.getScopePath() + " to " + sp.getEnclosingScopePath());
        }
        processInstance.setScopePath(sp.getEnclosingScopePath());
        return true;
    }

    public void release() {
        this.props = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

