/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.action.internal.ActionException;
import org.apache.ode.bpe.action.internal.IInternalAction;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.context.resolver.IResolvedObject;
import org.apache.ode.bpe.context.test.SerializationContext;
import org.apache.ode.bpe.correlation.keys.CorrelationKeysUtil;
import org.apache.ode.bpe.definition.IPMDCorrelation;
import org.apache.ode.bpe.definition.IPMDCorrelationSet;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ReturnMessageLocatorHolder;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.util.BPException;

public class ReplyAction
implements IInternalAction {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$bpel$ReplyAction == null ? (class$org$apache$ode$bpe$action$bpel$ReplyAction = ReplyAction.class$("org.apache.ode.bpe.action.bpel.ReplyAction")) : class$org$apache$ode$bpe$action$bpel$ReplyAction).getName());
    public static final String REPLY_FAULT_NAME = "REPLY_FAULT_NAME";
    public static final String REPLY_NAMESPACE = "REPLY_NAMESPACE";
    private Properties props;
    private String faultName;
    private String faultNS;
    private ArrayList operations;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$bpel$ReplyAction;

    public void init(Properties properties) throws ActionException {
        this.props = properties;
        this.operations = (ArrayList)((Hashtable)properties).get("operations");
        this.faultName = this.props.getProperty(REPLY_FAULT_NAME);
        this.faultNS = this.props.getProperty(REPLY_NAMESPACE);
    }

    public boolean execute(ContextResolver resolver, IEvaluationContext ec, IProcessCallBack pcb, IPMIProcess processInstance, IPMDProcess processDefinition) throws BPException {
        try {
            SerializationContext sc = new SerializationContext(System.out);
            sc.printComment("Reply Action Context:");
            sc.serialize(resolver.getContextService());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (logger.isLoggable(Level.FINE)) {
            Enumeration e = ((Hashtable)this.props).elements();
            StringBuffer sb = new StringBuffer();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof String)) continue;
                sb.append((String)o);
                sb.append("  ");
            }
            logger.fine("Reply Props:" + sb.toString());
        }
        ReturnMessageLocatorHolder rmlh = new ReturnMessageLocatorHolder();
        rmlh.setProcessID(processInstance.getKey());
        rmlh.setRootProcessID(processInstance.getRootKey());
        rmlh.setScopePath(processInstance.getScopePath());
        if (this.faultName != null) {
            rmlh.setFaultName(this.faultName);
            rmlh.setFaultNS(this.faultNS);
        }
        Iterator it = resolver.getLocatorHolder().getLocators();
        while (it.hasNext()) {
            String name;
            String[] name_split;
            ContextResolvedObject var;
            IPMDLocator loc = (IPMDLocator)it.next();
            rmlh.addLocator(loc.getName(), loc);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Adding locator to event directory reply:" + loc.getName());
            }
            if ((var = (ContextResolvedObject)resolver.resolveBPContext(loc.getName())).getValue() != null || ReplyAction.isCorrelationLocator((name_split = (name = loc.getName()).split(":"))[0], this.operations)) continue;
            throw new BPException("REPLY_ERROR", new Object[]{processDefinition.getRoot().getLabel(), processDefinition.getRoot().getKey().getValue(), processDefinition.getLabel(), loc.getName()});
        }
        pcb.setReturnMessageMetadata(rmlh);
        if (this.operations != null && CorrelationKeysUtil.hasCorrelationSets(this.operations)) {
            Map parts = this.getCorrelationParts(resolver, rmlh, this.operations, rmlh);
            CorrelationKeysUtil.setCorrelationKeys(resolver, parts, this.operations, null);
        }
        return true;
    }

    public void release() {
        this.props = null;
    }

    private Map getCorrelationParts(ContextResolver resolver, IPMDLocatorHolder lh, Collection operations, ReturnMessageLocatorHolder rmlh) throws BPException {
        HashMap<String, IInteraction> parts = new HashMap<String, IInteraction>();
        ArrayList<String> corrlsets = new ArrayList<String>();
        Iterator it = lh.getLocators();
        while (it.hasNext()) {
            IPMDLocator loc = (IPMDLocator)it.next();
            String name = loc.getName();
            String[] name_split = name.split(":");
            if (!ReplyAction.isCorrelationLocator(name_split[0], operations)) {
                IResolvedObject ro = resolver.resolveBPContext(loc.getName());
                Object obj = ro.getValue();
                IInteraction interaction = null;
                if (obj instanceof IInteraction) {
                    interaction = (IInteraction)ro.getValue();
                } else if (obj instanceof String) {
                    interaction = InteractionFactory.newInstance().createXMLInteraction(((String)ro.getValue()).getBytes());
                }
                parts.put(name_split[1], interaction);
                continue;
            }
            corrlsets.add(name_split[0]);
        }
        rmlh.setCorrlSets(corrlsets);
        return parts;
    }

    private static boolean isCorrelationLocator(String corrlName, Collection operations) {
        boolean ret = false;
        Iterator opIter = operations.iterator();
        block0: while (opIter.hasNext()) {
            IPMDOperation op = (IPMDOperation)opIter.next();
            IPMDCorrelation correlation = op.getCorrelation();
            if (correlation == null) continue;
            Iterator corrlIter = correlation.getCorrelationSets().iterator();
            while (corrlIter.hasNext()) {
                IPMDCorrelationSet cs = (IPMDCorrelationSet)corrlIter.next();
                String[] name = cs.getName().split(":");
                if (name.length <= 1 || !corrlName.equals(name[1])) continue;
                ret = true;
                continue block0;
            }
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

