/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.action.external;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.ode.bpe.action.external.IExternalAction;
import org.apache.ode.bpe.action.external.IURIResolver;
import org.apache.ode.bpe.scope.service.BPRuntimeException;

public class JMSPutAction
implements IExternalAction {
    static final long serialVersionUID = 856846540609589525L;
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$action$external$JMSPutAction == null ? (class$org$apache$ode$bpe$action$external$JMSPutAction = JMSPutAction.class$("org.apache.ode.bpe.action.external.JMSPutAction")) : class$org$apache$ode$bpe$action$external$JMSPutAction).getName());
    private String m_initialContextFactoryName;
    private String m_queueConnectionFactoryName;
    private String m_queueName;
    private String m_providerURL;
    private String m_payload;
    public static final String INITIAL_CONTEXT_FACTORY_KEY = "initialContextFactory";
    public static final String JMS_QUEUE_CONNECTION_FACTORY_KEY = "jmsQueueConnectionFactory";
    public static final String JMS_QUEUE_NAME_KEY = "jmsQueueName";
    public static final String PROVIDER_URL_KEY = "providerURL";
    public static final String PAYLOAD_KEY = "payload";
    private QueueSender m_queueSender;
    private QueueSession m_queueSession;
    private QueueConnection m_queueConnection;
    static /* synthetic */ Class class$org$apache$ode$bpe$action$external$JMSPutAction;

    public void init(Properties props) throws BPRuntimeException {
        this.m_initialContextFactoryName = props.getProperty(INITIAL_CONTEXT_FACTORY_KEY);
        this.m_queueConnectionFactoryName = props.getProperty(JMS_QUEUE_CONNECTION_FACTORY_KEY);
        this.m_queueName = props.getProperty(JMS_QUEUE_NAME_KEY);
        this.m_providerURL = props.getProperty(PROVIDER_URL_KEY);
        this.m_payload = props.getProperty(PAYLOAD_KEY);
        try {
            InitialContext context;
            if (this.m_initialContextFactoryName == null) {
                context = new InitialContext();
            } else {
                ((Hashtable)props).put("java.naming.factory.initial", this.m_initialContextFactoryName);
                ((Hashtable)props).put("java.naming.provider.url", this.m_providerURL);
                context = new InitialContext(props);
            }
            QueueConnectionFactory qcf = (QueueConnectionFactory)context.lookup(this.m_queueConnectionFactoryName);
            this.m_queueConnection = qcf.createQueueConnection();
            this.m_queueSession = this.m_queueConnection.createQueueSession(false, 1);
            Queue queue = (Queue)context.lookup(this.m_queueName);
            this.m_queueSender = this.m_queueSession.createSender(queue);
        }
        catch (NamingException e) {
            BPRuntimeException bp = new BPRuntimeException(null, "NATIVE_EXCEPTION", new Object[]{"NamingException"}, e);
            bp.log(logger, Level.SEVERE);
            throw bp;
        }
        catch (JMSException e) {
            BPRuntimeException bp = new BPRuntimeException(null, "NATIVE_EXCEPTION", new Object[]{"JMSException"}, e);
            bp.log(logger, Level.SEVERE);
            throw bp;
        }
    }

    public void execute(HashMap input, HashMap output, IURIResolver resolver) throws BPRuntimeException {
        Object payload = input.get(this.m_payload);
        try {
            BytesMessage message = null;
            if (payload instanceof byte[]) {
                BytesMessage bytesMessage = this.m_queueSession.createBytesMessage();
                bytesMessage.writeBytes((byte[])payload);
                message = bytesMessage;
            } else if (payload instanceof String) {
                TextMessage textMessage = this.m_queueSession.createTextMessage();
                textMessage.setText((String)payload);
                message = textMessage;
            } else {
                ObjectMessage objectMessage = this.m_queueSession.createObjectMessage();
                objectMessage.setObject((Serializable)payload);
                message = objectMessage;
            }
            this.m_queueSender.send((Message)message);
        }
        catch (Exception e) {
            BPRuntimeException bp = new BPRuntimeException(null, "NATIVE_EXCEPTION", new Object[]{"Exception"}, e);
            bp.log(logger, Level.SEVERE);
            throw bp;
        }
    }

    public void release() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

