/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.bped;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.bped.EventDirectorException;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.correlation.CorrelationService;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.ITimerEvent;
import org.apache.ode.bpe.event.LoadDefinitionEvent;
import org.apache.ode.bpe.event.StateEvent;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.scope.service.IFCScopeInstance;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.timerservice.IBPETimer;
import org.apache.ode.bpe.util.BPException;

public class EventDirectorUtil {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$bped$EventDirectorUtil == null ? (class$org$apache$ode$bpe$bped$EventDirectorUtil = EventDirectorUtil.class$("org.apache.ode.bpe.bped.EventDirectorUtil")) : class$org$apache$ode$bpe$bped$EventDirectorUtil).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$bped$EventDirectorUtil;

    public static void activate(IInternalEventDirector ed, String rootKey, String procKey) throws BPException {
        StateEvent se = new StateEvent(rootKey, procKey, StateEnum.STARTED);
        ed.sendEvent(se, true);
    }

    public static void terminate(IInternalEventDirector ed, String rootKey, String procKey) throws BPException {
        StateEvent se = new StateEvent(rootKey, procKey, StateEnum.TERMINATED);
        ed.sendEvent(se, true);
    }

    public static void pause(IInternalEventDirector ed, String rootKey, String procKey) throws BPException {
        StateEvent se = new StateEvent(rootKey, procKey, StateEnum.PAUSED);
        ed.sendEvent(se, true);
    }

    public static void handleStateEvent(IInternalEventDirector ed, ProcessService ps, StateEvent se) throws BPException {
        ProcessInstance pi = ps.lookupProcess(se.getRootProcessInstanceKey(), se.getProcessInstanceKey());
        pi.processEvent(se, ed, ed);
        InstanceService is = ps.getInstanceService();
        IPMIProcess ipmip = is.getInstance(se.getRootProcessInstanceKey(), se.getRootProcessInstanceKey());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("updatting instance service and removing lock for:" + ipmip.getRootKey());
        }
        ed.getProcessService().update(ipmip.getRootKey(), ed, ed);
    }

    public static void handleLoadDefintionEvent(IInternalEventDirector ed, LoadDefinitionEvent lde) throws BPException {
        DefinitionService ds = ed.getProcessService().getInstanceService().getDefinitionService();
        ds.loadDefintion(new ProcessDefinitionKey(lde.getDefinitionName()), ed);
    }

    public static void handleTimerEvent(IInternalEventDirector ed, IBPETimer timer) throws EventDirectorException {
        try {
            ProcessInstance pi;
            ITimerEvent te = timer.getTimerEvent();
            CorrelationService cs = ed.getCorrelationService();
            ProcessService ps = ed.getProcessService();
            InstanceService is = ps.getInstanceService();
            DefinitionService ds = is.getDefinitionService();
            if (te.getDefId() == null) {
                pi = ed.getProcessService().lookupProcess(te.getRootId(), te.getProcId());
            } else {
                ProcessDefinitionKey rpdk = new ProcessDefinitionKey(te.getRootDefId());
                ProcessDefinitionKey pdk = new ProcessDefinitionKey(te.getDefId());
                IPMDProcess ipmd = ds.getProcessDefintion(pdk, rpdk);
                IPMIProcess ipmi = is.getInstance(te.getRootId(), te.getRootId());
                pi = ps.createSubProcess(ipmi, ipmd);
                pi.setState(StateEnum.STARTED);
                ProcessInstance regProc = ed.getProcessService().lookupProcess(te.getRootId(), te.getProcId());
                pi.setScopePath(regProc.getScopePath());
            }
            String rootKey = pi.getRootKey();
            ps.init();
            cs.lock(ed, rootKey);
            IScopeService ss = pi.getScopeService();
            IFCScopeInstance scope = ss.getScope(pi.getScopePath());
            scope.removeTimer(timer);
            pi.processEvent(te, ed, ed);
            ps.update(rootKey, ed, ed);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

