/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.base;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.ode.bpe.cc.client.DefinitionState;
import org.apache.ode.bpe.cc.client.EngineState;
import org.apache.ode.bpe.cc.client.InstanceState;
import org.apache.ode.bpe.cc.data.DefinitionData;
import org.apache.ode.bpe.cc.data.EngineData;
import org.apache.ode.bpe.cc.data.InstanceData;
import org.apache.ode.bpe.cc.data.OperationData;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.enginestate.service.IEngineState;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.util.BPException;

public class DataExtractor {
    public static Collection getDefinitionData(Collection defs) throws BPException {
        LinkedList<DefinitionData> dataCollection = new LinkedList<DefinitionData>();
        Iterator iter = defs.iterator();
        while (iter.hasNext()) {
            IPMDRoot rootDef = (IPMDRoot)iter.next();
            DefinitionData dd = DataExtractor.getDefinitionData(rootDef);
            dataCollection.add(dd);
        }
        return dataCollection;
    }

    public static DefinitionData getDefinitionData(IPMDRoot def) throws BPException {
        DefinitionData dd = new DefinitionData();
        dd.setID(def.getProcess().getKey().getValue());
        dd.setName(def.getLabel());
        DefinitionState defState = DataExtractor.createDefinitionState(def.getState());
        dd.setState(defState);
        return dd;
    }

    public static DefinitionState createDefinitionState(int iState) {
        if (DefinitionState.ACTIVE.intValue() == iState) {
            return DefinitionState.ACTIVE;
        }
        if (DefinitionState.INACTIVE.intValue() == iState) {
            return DefinitionState.INACTIVE;
        }
        return DefinitionState.UNKNOWN;
    }

    public static Collection getInstanceData(Collection instances) throws BPException {
        Iterator iter = instances.iterator();
        LinkedList<InstanceData> returnValue = new LinkedList<InstanceData>();
        while (iter.hasNext()) {
            IPMIProcess instance = (IPMIProcess)iter.next();
            InstanceData instanceData = DataExtractor.getInstanceData(instance);
            returnValue.add(instanceData);
        }
        return returnValue;
    }

    public static InstanceData getInstanceData(IPMIProcess instance) throws BPException {
        InstanceData instanceData = new InstanceData();
        String id = instance.getKey();
        instanceData.setID(id);
        instanceData.setState(DataExtractor.createInstanceState(instance.getState()));
        return instanceData;
    }

    public static EngineData getEngineData(IEngineState engine) throws BPException {
        EngineData engineData = new EngineData();
        String id = engine.getId();
        engineData.setID(id);
        engineData.setState(DataExtractor.createEngineState(engine.getState()));
        return engineData;
    }

    public static InstanceState createInstanceState(int state) {
        switch (state) {
            case 4: {
                return InstanceState.FINISHED;
            }
            case 1: {
                return InstanceState.STARTED;
            }
            case 3: {
                return InstanceState.PAUSED;
            }
            case 6: {
                return InstanceState.RUNNING;
            }
            case 5: {
                return InstanceState.TERMINATED;
            }
        }
        return InstanceState.UNKNOWN;
    }

    public static EngineState createEngineState(String state) {
        if (EngineState.PAUSED.equals(state)) {
            return EngineState.PAUSED;
        }
        return EngineState.RUNNING;
    }

    public static Collection createOperationData(Collection operations) {
        Iterator iter = operations.iterator();
        LinkedList<OperationData> returnCollection = new LinkedList<OperationData>();
        while (iter.hasNext()) {
            IPMDOperation pmdOperation = (IPMDOperation)iter.next();
            returnCollection.add(DataExtractor.createOperationData(pmdOperation));
        }
        return returnCollection;
    }

    public static OperationData createOperationData(IPMDOperation operation) {
        BPELStaticKey key = (BPELStaticKey)operation.getKey();
        OperationData data = new OperationData(key.getTargetNamespace(), key.getPortType(), key.getOperation(), key.toString());
        return data;
    }
}

