/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ode.bpe.cc.client.IDefinition;
import org.apache.ode.bpe.cc.client.IEngine;
import org.apache.ode.bpe.cc.client.IInstance;
import org.apache.ode.bpe.cc.client.IProcessCreatingOperation;
import org.apache.ode.bpe.cc.client.IRegistration;
import org.apache.ode.bpe.cc.client.IScope;
import org.apache.ode.bpe.cc.client.IStatistical;
import org.apache.ode.bpe.cc.client.IVariable;
import org.apache.ode.bpe.cc.client.IVariablePart;
import org.apache.ode.bpe.cc.util.CCNode;
import org.apache.ode.bpe.cc.util.CCTreeBuilder;

public class CCReader {
    private CCTreeBuilder m_treeBuilder;
    public static final String NAME = "name";
    public static final String ID = "id";
    public static final String STATE = "state";
    public static final String VALUE = "value";
    public static final String DEF = "definition";
    public static final String ENGINE = "engine";
    public static final String INSTANCE = "instance";
    public static final String SCOPE = "scope";
    public static final String VARIABLE = "variable";
    public static final String PART = "part";
    public static final String REGISTRATION = "registration";
    public static final String PORT_TYPE = "portType";
    public static final String OPERATION = "operation";
    public static final String NAMESPACE = "namespace";
    public static final String DYNAMIC_KEY = "dynamicKey";
    public static final String STATISTIC = "statistic";
    public static final String PROCESS_CREATING_OPERATION = "processCreatingOperation";
    public static final String STATIC_KEY = "staticKey";
    public static final String PCO = "processCreatingOperations";
    public static final String PROCESS_INSTANCES = "processInstances";

    public CCNode readEngine(IEngine iEngine) throws Exception {
        this.m_treeBuilder = new CCTreeBuilder();
        this.m_treeBuilder.pushChild(ENGINE);
        this.readStatistics(iEngine);
        Collection definitions = iEngine.getDefinitions();
        Iterator definitionIter = definitions.iterator();
        while (definitionIter.hasNext()) {
            this.m_treeBuilder.addProperty(NAME, iEngine.getName());
            this.m_treeBuilder.addProperty(ID, iEngine.getID());
            this.m_treeBuilder.addProperty(STATE, iEngine.getState());
            IDefinition def = (IDefinition)definitionIter.next();
            this.readDefinition(def);
        }
        return this.m_treeBuilder.getTree();
    }

    private void readStatistics(IStatistical statistical) throws Exception {
        Map stats = statistical.getStatistics();
        Set entrySet = stats.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            this.m_treeBuilder.pushChild(STATISTIC);
            this.m_treeBuilder.addProperty(name, value);
            this.m_treeBuilder.pop();
        }
    }

    private void readDefinition(IDefinition def) throws Exception {
        this.m_treeBuilder.pushChild(DEF);
        this.readStatistics(def);
        this.m_treeBuilder.addProperty(NAME, def.getName());
        this.m_treeBuilder.addProperty(ID, def.getID());
        this.m_treeBuilder.addProperty(STATE, def.getState());
        Collection creatingOperations = def.getProcessCreatingOperations();
        Iterator operationIter = creatingOperations.iterator();
        this.m_treeBuilder.pushChild(PCO);
        while (operationIter.hasNext()) {
            IProcessCreatingOperation pco = (IProcessCreatingOperation)operationIter.next();
            this.readOperation(pco);
        }
        this.m_treeBuilder.pop();
        this.m_treeBuilder.pushChild(PROCESS_INSTANCES);
        Collection instances = def.getInstances();
        Iterator instanceIterator = instances.iterator();
        while (instanceIterator.hasNext()) {
            IInstance instance = (IInstance)instanceIterator.next();
            this.readInstance(instance);
        }
        this.m_treeBuilder.pop();
        this.m_treeBuilder.pop();
    }

    public CCNode readInstanceNode(IInstance instance, boolean recursive) throws Exception {
        this.m_treeBuilder = new CCTreeBuilder();
        this.readInstance(instance, recursive);
        return this.m_treeBuilder.getTree();
    }

    private void readInstance(IInstance instance) throws Exception {
        this.readInstance(instance, true);
    }

    private void readInstance(IInstance instance, boolean recursive) throws Exception {
        this.m_treeBuilder.pushChild(INSTANCE);
        this.readStatistics(instance);
        if (recursive) {
            Collection registrations = instance.getRegistrations();
            Iterator regIter = registrations.iterator();
            while (regIter.hasNext()) {
                IRegistration nextReg = (IRegistration)regIter.next();
                this.readRegistration(nextReg);
            }
        }
        this.m_treeBuilder.addProperty(ID, instance.getID());
        this.m_treeBuilder.addProperty(STATE, instance.getState());
        if (recursive) {
            IScope scope = instance.getRootContext();
            this.readScope(scope);
        }
        this.m_treeBuilder.pop();
    }

    private void readRegistration(IRegistration registration) {
        this.m_treeBuilder.pushChild(REGISTRATION);
        this.m_treeBuilder.addProperty(OPERATION, registration.getOperation());
        this.m_treeBuilder.addProperty(PORT_TYPE, registration.getPortType());
        this.m_treeBuilder.addProperty(NAMESPACE, registration.getTargetNamespace());
        this.m_treeBuilder.addProperty(DYNAMIC_KEY, registration.getDynamicKey());
        this.m_treeBuilder.addProperty(NAME, registration.getName());
        this.m_treeBuilder.pop();
    }

    private void readScope(IScope scope) throws Exception {
        if (scope == null) {
            return;
        }
        this.m_treeBuilder.pushChild(SCOPE);
        this.m_treeBuilder.addProperty(NAME, scope.getName());
        Collection variables = scope.getVariables();
        Iterator variableIter = variables.iterator();
        while (variableIter.hasNext()) {
            this.readVariable((IVariable)variableIter.next());
        }
        Collection childScopes = scope.getChildScopes();
        Iterator scopeIter = childScopes.iterator();
        while (scopeIter.hasNext()) {
            this.readScope((IScope)scopeIter.next());
        }
        this.m_treeBuilder.pop();
    }

    private void readVariable(IVariable iVariable) throws Exception {
        this.m_treeBuilder.pushChild(VARIABLE);
        this.m_treeBuilder.addProperty(NAME, iVariable.getName());
        Collection parts = iVariable.getParts();
        Iterator partIterator = parts.iterator();
        while (partIterator.hasNext()) {
            this.readPart((IVariablePart)partIterator.next());
        }
        this.m_treeBuilder.pop();
    }

    private void readPart(IVariablePart part) throws Exception {
        this.m_treeBuilder.pushChild(PART, part.getValue());
        this.m_treeBuilder.addProperty(NAME, part.getName());
        this.m_treeBuilder.pop();
    }

    private void readOperation(IProcessCreatingOperation operation) {
        this.m_treeBuilder.pushChild(PROCESS_CREATING_OPERATION);
        this.m_treeBuilder.addProperty(OPERATION, operation.getOperationName());
        this.m_treeBuilder.addProperty(NAMESPACE, operation.getPortTypeNamespace());
        this.m_treeBuilder.addProperty(PORT_TYPE, operation.getPortType());
        this.m_treeBuilder.addProperty(STATIC_KEY, operation.getStaticKey());
        this.m_treeBuilder.pop();
    }
}

