/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.cc.util.ops;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.ode.bpe.cc.client.CCClient;
import org.apache.ode.bpe.cc.client.CCException;
import org.apache.ode.bpe.cc.client.ICCClient;
import org.apache.ode.bpe.cc.client.IDefinition;
import org.apache.ode.bpe.cc.client.IEngine;
import org.apache.ode.bpe.cc.client.IInstance;
import org.apache.ode.bpe.cc.util.ops.ActivateAllDefinitions;
import org.apache.ode.bpe.cc.util.ops.DeactivateAllDefinitions;
import org.apache.ode.bpe.cc.util.ops.ICCOp;
import org.apache.ode.bpe.cc.util.ops.PauseAllInstances;
import org.apache.ode.bpe.cc.util.ops.PauseInstance;
import org.apache.ode.bpe.cc.util.ops.QueryEngine;
import org.apache.ode.bpe.cc.util.ops.QueryInstance;
import org.apache.ode.bpe.cc.util.ops.RemoveAllDefinitions;
import org.apache.ode.bpe.cc.util.ops.RemoveAllInstances;
import org.apache.ode.bpe.cc.util.ops.ResumeAllInstances;
import org.apache.ode.bpe.cc.util.ops.ResumeInstance;
import org.apache.ode.bpe.cc.util.ops.TerminateAllInstances;

public class CCUtil {
    private HashMap m_operations = new HashMap();
    private String[] m_args;
    private Properties m_argumentProperties = new Properties();
    private ICCClient m_client;
    private IEngine m_engine;

    private String getPackageName() {
        return this.m_argumentProperties.getProperty("pkg", "BPE");
    }

    private void addOperations() {
        this.addOperation(new PauseInstance());
        this.addOperation(new QueryInstance());
        this.addOperation(new ResumeInstance());
        this.addOperation(new PauseAllInstances());
        this.addOperation(new ResumeAllInstances());
        this.addOperation(new TerminateAllInstances());
        this.addOperation(new RemoveAllInstances());
        this.addOperation(new QueryEngine());
        this.addOperation(new ActivateAllDefinitions());
        this.addOperation(new DeactivateAllDefinitions());
        this.addOperation(new RemoveAllDefinitions());
    }

    public CCUtil(String[] args) {
        this.m_args = args;
        this.buildArgumentProperties(this.m_args);
        this.addOperations();
    }

    private void buildArgumentProperties(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String[] nv = args[i].split("\\.");
            if (nv.length == 2) {
                ((Hashtable)this.m_argumentProperties).put(nv[0], nv[1]);
                continue;
            }
            this.getPrintStream().println("Invalid argument:" + args[i]);
            this.getPrintStream().println("Arguments should be of the form: name=value");
        }
    }

    public void addOperation(ICCOp operation) {
        this.m_operations.put(operation.getClass().getName(), operation);
    }

    public static void main(String[] iArgs) {
        CCUtil util = new CCUtil(iArgs);
        util.run();
    }

    private void run() {
        Iterator iter = this.m_operations.values().iterator();
        boolean hit = false;
        while (iter.hasNext()) {
            ICCOp operation = (ICCOp)iter.next();
            if (!operation.supports(this.m_argumentProperties)) continue;
            hit = true;
            this.invokeOperation(operation);
            this.getPrintStream().println(operation.getName() + " operation completed normally.");
        }
        if (!hit) {
            this.dumpUsage();
        }
    }

    public PrintStream getPrintStream() {
        return System.out;
    }

    private void dumpUsage() {
        Iterator iter = this.m_operations.values().iterator();
        this.getPrintStream().println("Supported usages:");
        while (iter.hasNext()) {
            ICCOp operation = (ICCOp)iter.next();
            System.out.println("     CCUtil [pkg.<package name>] " + operation.getUsage());
        }
    }

    private void invokeOperation(ICCOp operation) {
        operation.setConnection(this);
        operation.setArgs(this.m_argumentProperties);
        operation.invoke();
    }

    public OutputStream getOutputStream() {
        return this.getPrintStream();
    }

    private ICCClient getClient() {
        if (this.m_client == null) {
            try {
                this.m_client = new CCClient();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.m_client;
    }

    public IEngine getEngine() {
        if (this.m_engine == null) {
            HashMap<String, String> hm = new HashMap<String, String>();
            hm.put("ENGINE_NAME", this.getPackageName());
            try {
                this.m_engine = this.getClient().getEngine(hm);
            }
            catch (CCException e) {
                throw new RuntimeException(e);
            }
        }
        return this.m_engine;
    }

    public IInstance getInstance(String instanceID) {
        try {
            IEngine engine = this.getClient().getEngine();
            IInstance instance = engine.getInstance(instanceID);
            return instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection getAllInstances() {
        LinkedList instances = new LinkedList();
        try {
            Collection definitions = this.getClient().getEngine().getDefinitions();
            Iterator iter = definitions.iterator();
            while (iter.hasNext()) {
                IDefinition definition = (IDefinition)iter.next();
                Collection defInstances = definition.getInstances();
                instances.addAll(defInstances);
            }
        }
        catch (CCException e) {
            throw new RuntimeException(e);
        }
        return instances;
    }
}

