/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.client.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.ode.bpe.action.external.ActionSystemException;
import org.apache.ode.bpe.client.DescribedValue;
import org.apache.ode.bpe.client.IDescribedValue;
import org.apache.ode.bpe.client.IFormattableValue;
import org.apache.ode.bpe.client.impl.IInternalMessage;
import org.apache.ode.bpe.client.impl.IInternalResult;
import org.apache.ode.bpe.client.impl.def.InternalMessage;
import org.apache.ode.bpe.client.impl.def.InternalResult;
import org.apache.ode.bpe.client.spi.interaction.ISPIInteraction;
import org.apache.ode.bpe.engine.InactiveDefinitionException;
import org.apache.ode.bpe.engine.ProcessInstancePausedException;
import org.apache.ode.bpe.event.Fault;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.event.SimpleRequestMessageEvent;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.spiadapter.SPIAdapterInteraction;
import org.apache.ode.bpe.interaction.spiimpl.MasterInteractionFactory;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.util.BPException;

public class MessageConverter {
    public IRequestMessageEvent createRequest(IStaticKey key, IInternalMessage internalRequest) {
        SimpleRequestMessageEvent srm = new SimpleRequestMessageEvent();
        srm.setStaticKey(key);
        Map requestParts = internalRequest.getParts();
        Iterator iter = requestParts.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            IDescribedValue dv = (IDescribedValue)entry.getValue();
            ISPIInteraction spi = MasterInteractionFactory.newInstance().createInteraction(dv);
            SPIAdapterInteraction spiai = new SPIAdapterInteraction(spi);
            try {
                srm.setPart(name, spiai);
            }
            catch (BPException e) {
                throw new RuntimeException(e);
            }
        }
        return srm;
    }

    static IInternalMessage createInternalMessage(Map parts) {
        InternalMessage im = new InternalMessage();
        Iterator iter = parts.entrySet().iterator();
        HashMap<String, IFormattableValue> internalParts = new HashMap<String, IFormattableValue>();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            IFormattableValue fv = null;
            if (value instanceof IInteraction) {
                IInteraction interaction = null;
                interaction = (IInteraction)entry.getValue();
                if (interaction != null && interaction instanceof SPIAdapterInteraction) {
                    fv = ((SPIAdapterInteraction)interaction).getUserValue();
                }
            } else {
                IDescribedValue describedValue = null;
                describedValue = value instanceof IDescribedValue ? (IDescribedValue)value : new DescribedValue(value);
                ISPIInteraction interaction = MasterInteractionFactory.newInstance().createInteraction(describedValue);
                fv = interaction.getValue();
            }
            internalParts.put(name, fv);
        }
        im.setParts(internalParts);
        return im;
    }

    public IInternalResult createResult(IResponseMessage response) {
        Map map = response.getParts();
        InternalResult iresult = new InternalResult();
        Exception faultException = null;
        try {
            Fault fault = response.getFault();
            if (fault != null) {
                faultException = fault.getFaultException();
            }
        }
        catch (BPException e) {
            throw new RuntimeException(e);
        }
        if (faultException != null) {
            if (faultException instanceof BPRuntimeException) {
                MessageConverter.PopulateBusinessProcessFaultResult(iresult, (BPRuntimeException)faultException);
            } else if (faultException instanceof ProcessInstancePausedException) {
                MessageConverter.PopulatePausedInstanceException(iresult, (ProcessInstancePausedException)faultException);
            } else if (faultException instanceof InactiveDefinitionException) {
                MessageConverter.PopulateInactiveDefinitionException(iresult, (InactiveDefinitionException)faultException);
            } else {
                MessageConverter.PopulateSystemExceptionResult(iresult, faultException);
            }
        } else {
            IInternalMessage im = MessageConverter.createInternalMessage(map);
            iresult.setSuccessfulResponse(im);
            iresult.setResultType(3);
        }
        return iresult;
    }

    public static void PopulateSystemExceptionResult(InternalResult iresult, Exception faultException) {
        iresult.setResultType(100);
        iresult.setExceptionName(faultException.getClass().getName());
        iresult.setExceptionStackTrace(faultException.getStackTrace());
        iresult.setExceptionString(faultException.toString());
        if (faultException instanceof ActionSystemException) {
            iresult.setExceptionProperties(((ActionSystemException)faultException).getProperties());
        }
    }

    public static void PopulateBusinessProcessFaultResult(InternalResult internalResult, BPRuntimeException bpre) {
        HashMap faultParts = bpre.getMessageParts();
        IInternalMessage im = MessageConverter.createInternalMessage(faultParts);
        internalResult.setFaultName(bpre.getName());
        internalResult.setFaultNamespace(bpre.getNameSpace());
        internalResult.setResultType(1);
        internalResult.setFaultMessage(im);
    }

    public static void PopulatePausedInstanceException(InternalResult internalResult, ProcessInstancePausedException pipe) {
        internalResult.setResultType(105);
        internalResult.setID(pipe.getRootInstanceID());
        internalResult.setExceptionStackTrace(pipe.getStackTrace());
    }

    public static void PopulateInactiveDefinitionException(InternalResult internalResult, InactiveDefinitionException iade) {
        internalResult.setResultType(106);
        internalResult.setID(iade.getRootDefinitionID());
        internalResult.setDefinitionName(iade.getProcessName());
        internalResult.setExceptionStackTrace(iade.getStackTrace());
    }
}

