/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.resolver;

import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.IPart;
import org.apache.ode.bpe.context.base.ContextServiceException;
import org.apache.ode.bpe.context.resolver.ContextResolvedObject;
import org.apache.ode.bpe.context.resolver.IResolvedObject;
import org.apache.ode.bpe.context.resolver.IResolver;
import org.apache.ode.bpe.context.resolver.ResolverException;
import org.apache.ode.bpe.context.resolver.ResolverVariableContext;
import org.apache.ode.bpe.context.test.SerializationContext;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDLocatorHolder;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.interaction.query.IQuery;
import org.apache.ode.bpe.interaction.query.JaxenXPathSingleNodeQuery;
import org.apache.ode.bpe.scope.service.IScopeService;
import org.apache.ode.bpe.util.BPException;
import org.jaxen.VariableContext;

public class ContextResolver
implements IResolver {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$context$resolver$ContextResolver == null ? (class$org$apache$ode$bpe$context$resolver$ContextResolver = ContextResolver.class$("org.apache.ode.bpe.context.resolver.ContextResolver")) : class$org$apache$ode$bpe$context$resolver$ContextResolver).getName());
    private IPMIProcess process;
    private IContextService cs;
    private IPMDLocatorHolder lc;
    private IScopeService ss;
    private IContainer rootCont;
    private IContainer globalCont;
    static /* synthetic */ Class class$org$apache$ode$bpe$context$resolver$ContextResolver;

    public ContextResolver(IPMIProcess process, IPMDLocatorHolder lc, IContextService cs, IScopeService ss) {
        this.process = process;
        this.lc = lc;
        this.cs = cs;
        this.ss = ss;
    }

    private IPart scopeIt(int depth, String scope, String path) throws ContextServiceException {
        IContainer foundContainer;
        int i;
        String[] scope_path = scope.split("/");
        String[] relpath = path.split("/");
        IPart foundPart = null;
        IContainer containerPointer = this.globalCont;
        for (i = depth; i < scope_path.length && (foundContainer = (IContainer)containerPointer.findChild(scope_path[i])) != null; ++i) {
            containerPointer = foundContainer;
        }
        for (i = 0; i < relpath.length - 1 && (foundContainer = (IContainer)containerPointer.findChild(relpath[i])) != null; ++i) {
            containerPointer = foundContainer;
        }
        try {
            foundPart = (IPart)containerPointer.findChild(relpath[relpath.length - 1]);
        }
        catch (ClassCastException cce) {
            foundPart = null;
        }
        if (foundPart == null) {
            if (depth < scope_path.length) {
                foundPart = this.scopeIt(depth + 1, scope, path);
            } else {
                return null;
            }
        }
        return foundPart;
    }

    private IPart getIt(String path) throws ContextServiceException {
        String[] pathing = path.split("/");
        IContainer containerPointer = this.globalCont;
        for (int i = 1; i < pathing.length - 1; ++i) {
            IContainer foundContainer = (IContainer)containerPointer.findChild(pathing[i]);
            if (foundContainer == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Creating container(" + this.process.getContextContainerId() + "):" + pathing[i]);
                }
                containerPointer = containerPointer.createContainer(pathing[i]);
                continue;
            }
            containerPointer = foundContainer;
        }
        IPart part = (IPart)containerPointer.findChild(pathing[pathing.length - 1]);
        if (part == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Creating part:(" + this.process.getContextContainerId() + ")" + pathing[pathing.length - 1]);
            }
            part = containerPointer.createPart(pathing[pathing.length - 1]);
        }
        return part;
    }

    public IResolvedObject resolveBPContext(String locator) throws BPException {
        IResolvedObject retVal = null;
        try {
            retVal = this.resolve(locator);
        }
        catch (ResolverException re) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"ResolverException"}, re);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return retVal;
    }

    public IResolvedObject resolveWithOutInvocation(String locator) throws BPException {
        IResolvedObject retVal = null;
        try {
            retVal = this.resolve(locator, false);
        }
        catch (ResolverException re) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"ResolverException"}, re);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return retVal;
    }

    public IResolvedObject resolveWithOutInvocation(IPMDLocator locator) throws BPException {
        IResolvedObject retVal = null;
        try {
            retVal = this.resolve(locator, false);
        }
        catch (ResolverException re) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"ResolverException"}, re);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return retVal;
    }

    public IResolvedObject resolve(String locator) throws ResolverException {
        return this.resolve(locator, true);
    }

    public IResolvedObject resolve(String locator, boolean invocation) throws ResolverException {
        IPMDLocator locatorObj = this.lc.getLocator(locator);
        return this.resolve(locatorObj, invocation);
    }

    public IResolvedObject resolve(IPMDLocator locatorObj, boolean invocation) throws ResolverException {
        Object returnObj;
        Object resolvedObj;
        IPart part;
        block7: {
            part = this.getPart(locatorObj);
            resolvedObj = this.getResolvedObject(locatorObj, part);
            returnObj = null;
            try {
                IInvocation query = locatorObj.getQuery();
                if (query != null && invocation) {
                    IInteraction interaction = null;
                    if (resolvedObj instanceof String) {
                        resolvedObj = InteractionFactory.newInstance().createXMLInteraction(((String)resolvedObj).getBytes());
                    }
                    if ((interaction = (IInteraction)resolvedObj) == null) break block7;
                    IQuery iq = query.getQuery();
                    if (iq instanceof JaxenXPathSingleNodeQuery) {
                        JaxenXPathSingleNodeQuery jxp = (JaxenXPathSingleNodeQuery)iq;
                        try {
                            jxp.createLocator().setVariableContext((VariableContext)new ResolverVariableContext(this));
                        }
                        catch (Exception e) {
                            throw new ResolverException(e);
                        }
                    }
                    returnObj = interaction.invoke(query);
                    break block7;
                }
                returnObj = resolvedObj;
            }
            catch (InteractionException e) {
                throw new ResolverException(e);
            }
        }
        return new ContextResolvedObject(locatorObj.getName(), returnObj, resolvedObj, locatorObj.getType(), part, locatorObj.getQuery(), locatorObj.getInteractionBuilder());
    }

    public IResolvedObject resolveForUpdateBPContext(String locator) throws BPException {
        IResolvedObject retVal = null;
        try {
            retVal = this.resolveForUpdate(locator);
        }
        catch (ResolverException re) {
            BPException bpx = new BPException("NATIVE_EXCEPTION", new Object[]{"ResolverException"}, re);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        return retVal;
    }

    public IResolvedObject resolveForUpdate(String locator) throws ResolverException {
        IQuery iq;
        IPMDLocator locatorObj = this.lc.getLocator(locator);
        IPart part = this.getPart(locatorObj);
        Object resolvedObj = this.getResolvedObject(locatorObj, part);
        if (locatorObj.getQuery() != null && (iq = locatorObj.getQuery().getQuery()) != null && iq instanceof JaxenXPathSingleNodeQuery) {
            JaxenXPathSingleNodeQuery jxp = (JaxenXPathSingleNodeQuery)iq;
            try {
                jxp.createLocator().setVariableContext((VariableContext)new ResolverVariableContext(this));
            }
            catch (Exception e) {
                throw new ResolverException(e);
            }
        }
        return new ContextResolvedObject(locator, null, resolvedObj, locatorObj.getType(), part, locatorObj.getQuery(), locatorObj.getInteractionBuilder());
    }

    private IPart getPart(IPMDLocator locatorObj) throws ResolverException {
        IPart part = null;
        try {
            this.rootCont = this.cs.getRoot();
            this.globalCont = (IContainer)this.rootCont.findChild(this.process.getContextContainerId());
            String path = this.process.getScopePath().applyPathIdsToPath(locatorObj.getPath());
            if (!locatorObj.isAbsolute()) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Trying to reslove relative path:" + path + " in context conainer:" + this.process.getContextContainerId());
                }
                if ((part = this.scopeIt(1, this.process.getScopePath().toString(), path)) == null) {
                    String fullPath = this.process.getScopePath().getScopeNamePath() + "/" + path;
                    part = this.getIt(fullPath);
                }
            } else {
                part = this.getIt(path);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Resloved path:" + path + " in context conainer:" + this.process.getContextContainerId() + "  to " + part);
                }
            }
        }
        catch (ContextServiceException e) {
            throw new ResolverException(e);
        }
        return part;
    }

    private Object getResolvedObject(IPMDLocator locatorObj, IPart part) throws ResolverException {
        Object resolvedObj = null;
        try {
            resolvedObj = locatorObj.getForOutput() && locatorObj.getContentious() ? part.getObjectForReadWrite() : (locatorObj.getForOutput() ? part.getObjectForReadWrite() : part.getObjectForRead());
            if (logger.isLoggable(Level.FINEST)) {
                SerializationContext sc = new SerializationContext(System.out);
                sc.serialize(this.cs);
            }
        }
        catch (ContextServiceException e) {
            throw new ResolverException(e);
        }
        catch (Exception e) {
            throw new ResolverException(e);
        }
        return resolvedObj;
    }

    public IScopeService getScopeService() {
        return this.ss;
    }

    public IContextService getContextService() {
        return this.cs;
    }

    public IPMDLocatorHolder getLocatorHolder() {
        return this.lc;
    }

    public IPMIProcess getProcess() {
        return this.process;
    }

    public String getLoggingString(String locator) throws ResolverException {
        IPMDLocator locatorObj = this.lc.getLocator(locator);
        String rtnStr = "Variable: ";
        ArrayList al = locatorObj.getArrayListPath();
        int size = al.size();
        int index = size - 2;
        rtnStr = rtnStr + (String)al.get(index);
        rtnStr = rtnStr + ":";
        rtnStr = rtnStr + (String)al.get(++index);
        if (locatorObj.getQuery() != null) {
            rtnStr = rtnStr + " query: ";
            IQuery iq = locatorObj.getQuery().getQuery();
            if (iq instanceof JaxenXPathSingleNodeQuery) {
                JaxenXPathSingleNodeQuery jsnq = (JaxenXPathSingleNodeQuery)iq;
                try {
                    rtnStr = rtnStr + jsnq.getXPathExpression();
                }
                catch (Exception e) {
                    throw new ResolverException(e);
                }
            }
        }
        return rtnStr;
    }

    public String getResolvedVariableName(String locator) {
        IPMDLocator locatorObj = this.lc.getLocator(locator);
        ArrayList al = locatorObj.getArrayListPath();
        int size = al.size();
        int index = size - 2;
        String rtnStr = (String)al.get(index);
        rtnStr = rtnStr + ":";
        rtnStr = rtnStr + (String)al.get(++index);
        return rtnStr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

