/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.context.test;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import javax.transaction.UserTransaction;
import org.apache.ode.bpe.context.test.BMPContextServiceTest;
import org.apache.ode.bpe.context.test.CMPContextServiceTest;
import org.apache.ode.bpe.context.test.ContextServiceTest;
import org.apache.ode.bpe.context.test.J2EEContextServiceTest;
import org.apache.ode.bpe.context.test.TransientContextServiceTest;

public class ContextServiceTestSuite {
    public static final String OUTPUT_DIR = "/home/charper/tmp";
    private UserTransaction m_userTransaction = null;

    public ContextServiceTestSuite(UserTransaction iTransaction) {
        this.m_userTransaction = iTransaction;
    }

    public void testCMPMonolithic() throws Exception {
        CMPContextServiceTest tst = this.newCMP();
        this.setMonolithic(tst);
        this.setOutputStream(tst, "CMP_MONOLITHIC");
        this.run(tst);
    }

    public void testCMPFine() throws Exception {
        CMPContextServiceTest tst = this.newCMP();
        this.setFine(tst);
        this.setOutputStream(tst, "CMP_FINE");
        this.run(tst);
    }

    public void testCMPIntermediate() throws Exception {
        CMPContextServiceTest tst = this.newCMP();
        this.setIntermediate(tst);
        this.setOutputStream(tst, "CMP_INTERMEDIATE");
        this.run(tst);
    }

    public void testBMPMonolithic() throws Exception {
        BMPContextServiceTest tst = this.newBMP();
        this.setMonolithic(tst);
        this.setOutputStream(tst, "BMP_MONOLITHIC");
        this.run(tst);
    }

    public void testBMPFine() throws Exception {
        BMPContextServiceTest tst = this.newBMP();
        this.setFine(tst);
        this.setOutputStream(tst, "BMP_FINE");
        this.run(tst);
    }

    public void testBMPIntermediate() throws Exception {
        BMPContextServiceTest tst = this.newBMP();
        this.setIntermediate(tst);
        this.setOutputStream(tst, "BMP_INTERMEDIATE");
        this.run(tst);
    }

    public void testTransient() throws Exception {
        TransientContextServiceTest tst = this.newTransient();
        this.setOutputStream(tst, "TRANSIENT");
        this.run(tst);
    }

    private void setMonolithic(ContextServiceTest iTest) {
        iTest.setProperty("CTX_PERSISTENCE_GRANULARITY_KEY", "CTX_MONOLITHIC");
    }

    private void setFine(ContextServiceTest iTest) {
        iTest.setProperty("CTX_PERSISTENCE_GRANULARITY_KEY", "CTX_FINE");
    }

    private void setIntermediate(ContextServiceTest iTest) {
        iTest.setProperty("CTX_PERSISTENCE_GRANULARITY_KEY", "CTX_INTERMEDIATE");
    }

    private CMPContextServiceTest newCMP() {
        CMPContextServiceTest tst = new CMPContextServiceTest();
        this.setTransaction(tst);
        return tst;
    }

    private BMPContextServiceTest newBMP() {
        BMPContextServiceTest tst = new BMPContextServiceTest();
        this.setTransaction(tst);
        return tst;
    }

    private void setTransaction(J2EEContextServiceTest iTest) {
        iTest.init(this.m_userTransaction);
    }

    private TransientContextServiceTest newTransient() {
        return new TransientContextServiceTest();
    }

    private void setOutputStream(ContextServiceTest iTest, String iFileName) throws FileNotFoundException {
        FileOutputStream fos = new FileOutputStream("/home/charper/tmp/" + iFileName);
        iTest.setOutputStream(fos);
    }

    private void run(ContextServiceTest iTest) throws Exception {
        iTest.setProperty("XML_TEST_FILE", "/home/charper/xalan-j_2_4_1/samples/SimpleTransform/birds.xml");
        iTest.go();
        iTest.getOutputStream().close();
    }

    public void go() throws Exception {
        this.testCMPMonolithic();
        this.testCMPFine();
        this.testCMPIntermediate();
        this.testBMPMonolithic();
        this.testBMPFine();
        this.testBMPIntermediate();
        this.testTransient();
    }
}

