/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.correlation;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.ode.bpe.bped.IInternalEventDirector;
import org.apache.ode.bpe.context.IContainer;
import org.apache.ode.bpe.context.IContextService;
import org.apache.ode.bpe.context.resolver.ContextResolver;
import org.apache.ode.bpe.context.resolver.IResolvedObject;
import org.apache.ode.bpe.context.test.SerializationContext;
import org.apache.ode.bpe.correlation.CorrelationServiceException;
import org.apache.ode.bpe.correlation.PartQuery;
import org.apache.ode.bpe.correlation.Registration;
import org.apache.ode.bpe.definition.IPMDCorrelationSet;
import org.apache.ode.bpe.definition.IPMDLocator;
import org.apache.ode.bpe.definition.IPMDOperation;
import org.apache.ode.bpe.definition.IPMDProcess;
import org.apache.ode.bpe.definition.IPMDRoot;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.engine.ProcessDefinitionKey;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.ProcessService;
import org.apache.ode.bpe.engine.ReturnMessageLocatorHolder;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.BPELStaticKey;
import org.apache.ode.bpe.event.Fault;
import org.apache.ode.bpe.event.IRequestMessageEvent;
import org.apache.ode.bpe.event.IResponseMessage;
import org.apache.ode.bpe.event.IStaticKey;
import org.apache.ode.bpe.instance.IPMIProcess;
import org.apache.ode.bpe.instance.service.InstanceService;
import org.apache.ode.bpe.interaction.IInteraction;
import org.apache.ode.bpe.interaction.IInvocation;
import org.apache.ode.bpe.interaction.InteractionFactory;
import org.apache.ode.bpe.interaction.Invocation;
import org.apache.ode.bpe.interaction.query.JaxenXPathSingleNodeQuery;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.scope.service.BPRuntimeException;
import org.apache.ode.bpe.scope.service.ScopePath;
import org.apache.ode.bpe.util.BPEProperties;
import org.apache.ode.bpe.util.BPException;

public abstract class CorrelationService {
    private static Logger logger = Logger.getLogger((class$org$apache$ode$bpe$correlation$CorrelationService == null ? (class$org$apache$ode$bpe$correlation$CorrelationService = CorrelationService.class$("org.apache.ode.bpe.correlation.CorrelationService")) : class$org$apache$ode$bpe$correlation$CorrelationService).getName());
    static /* synthetic */ Class class$org$apache$ode$bpe$correlation$CorrelationService;

    public abstract void createRegistration(Registration var1) throws BPException;

    public abstract void removeRegistration(Registration var1) throws BPException;

    public abstract Collection getRegistrations(IStaticKey var1, Collection var2) throws BPException;

    public abstract Collection getRegistrations(IPMIProcess var1) throws BPException;

    public abstract Collection getRegistrations(IStaticKey var1) throws BPException;

    public abstract Registration getRegistration(IStaticKey var1, String var2, String var3) throws BPException;

    public void lock(IInternalEventDirector ed, String key) throws BPException {
        ed.getLockingService().lock(key);
    }

    public abstract void update() throws BPException;

    public abstract ProcessService getProcessService() throws BPException;

    public abstract boolean isBPELCompliant();

    public void routeToRegistration(Registration registration, IRequestMessageEvent me, IInternalEventDirector ed) throws BPException {
        String rootDefId = registration.getRootDefId();
        String defId = registration.getDefId();
        String rootProcId = registration.getRootProcId();
        String procId = registration.getProcId();
        String opId = registration.getOperationId();
        DefinitionService ds = this.getProcessService().getInstanceService().getDefinitionService();
        IPMDRoot root = ds.getRootDefinition(new ProcessDefinitionKey(rootDefId));
        IPMDOperation op = root.getOperation(opId);
        ProcessInstance pi = null;
        if (!op.isInstanceCreating()) {
            pi = this.getProcessService().lookupProcess(rootProcId, procId);
        } else {
            ProcessDefinitionKey rpdk = new ProcessDefinitionKey(rootDefId);
            ProcessDefinitionKey pdk = new ProcessDefinitionKey(defId);
            IPMDProcess ipmd = ds.getProcessDefintion(pdk, rpdk);
            IPMIProcess ipmi = this.getProcessService().getInstanceService().getInstance(rootProcId, rootProcId);
            pi = this.getProcessService().createSubProcess(ipmi, ipmd);
            pi.setState(StateEnum.STARTED);
            ProcessInstance regProc = this.getProcessService().lookupProcess(rootProcId, procId);
            pi.setScopePath(regProc.getScopePath());
        }
        pi.processEvent(me, ed, ed);
    }

    public void createInstanceAndRoute(IPMDOperation operation, IRequestMessageEvent me, IInternalEventDirector ed) throws BPException {
        ProcessDefinitionKey rpdk = new ProcessDefinitionKey(operation.getRootDefId());
        ProcessInstance pi = this.getProcessService().createProcess(rpdk);
        pi.setState(StateEnum.STARTED);
        IContextService ctxs = pi.getContextService();
        IContainer root = ctxs.getRoot();
        IContainer procroot = (IContainer)root.findChild(pi.getRootKey());
        if (procroot == null) {
            root.createContainer(pi.getRootKey());
        }
        pi.processEvent(me, ed, ed);
    }

    public abstract void init(BPEProperties var1, ProcessService var2) throws BPException;

    public IResponseMessage correlateEvent(IRequestMessageEvent me, boolean sync, IInternalEventDirector ed) throws BPException {
        this.getProcessService().init();
        ed.setMessageEvent(me);
        ed.setReturnMessageMetadata(null);
        IStaticKey key = me.getStaticKey();
        SentMessageData smd = new SentMessageData();
        Collection defOps = this.getAllDefinedNonInstanceCreatingOperations(key);
        Collection keys = this.computeKeys(me, defOps, false);
        Registration reg = null;
        if (this.isStatefull(defOps)) {
            reg = this.findRegistration(ed, key, keys);
        }
        if (reg != null) {
            this.routeToRegistration(reg, me, ed);
            this.sentMessage(smd, ed.getReturnMessageMetadata().getRootProcessID());
            return this.mapResult(smd, ed, sync);
        }
        IPMDOperation op = this.findInstanceCreatingOperation(key);
        if (op != null) {
            IPMDRoot root = this.getProcessService().getInstanceService().getDefinitionService().getRootDefinition(new ProcessDefinitionKey(op.getRootDefId()));
            if (root.getProtectedInstantiation() && !root.getIsStateless()) {
                this.lock(ed, op.getRootDefId());
                Registration regRecheck = this.findRegistration(ed, key, keys);
                if (regRecheck != null) {
                    this.routeToRegistration(regRecheck, me, ed);
                    this.sentMessage(smd, ed.getReturnMessageMetadata().getRootProcessID());
                    return this.mapResult(smd, ed, sync);
                }
            }
            this.createInstanceAndRoute(op, me, ed);
            this.sentMessage(smd, ed.getReturnMessageMetadata().getRootProcessID());
            return this.mapResult(smd, ed, sync);
        }
        if (defOps == null && op == null) {
            CorrelationServiceException cse = new CorrelationServiceException("ED_ED_NSR", new Object[]{key});
            cse.log(logger, Level.SEVERE);
            throw cse;
        }
        if (op == null) {
            BPELStaticKey bpelKey = (BPELStaticKey)key;
            Object[] obj = new Object[]{bpelKey.getOperation(), bpelKey.getPortType(), bpelKey.getTargetNamespace(), this.getCorrelationValues(me, defOps), this.getCorrelationKeys(defOps)};
            CorrelationServiceException cse = new CorrelationServiceException("ED_ED_NSR_R", obj);
            cse.log(logger, Level.SEVERE);
            throw cse;
        }
        return null;
    }

    private IPMDOperation findInstanceCreatingOperation(IStaticKey key) throws BPException {
        DefinitionService ds = this.getProcessService().getInstanceService().getDefinitionService();
        Collection ops = ds.getCorrelations(key);
        if (ops.size() == 0) {
            return null;
        }
        if (ops.size() > 1) {
            throw new CorrelationServiceException("CS_NO_SPRAY", new Object[0]);
        }
        IPMDOperation op = (IPMDOperation)ops.iterator().next();
        return op;
    }

    private Registration findRegistration(IInternalEventDirector ed, IStaticKey key, Collection keys) throws BPException {
        Collection registrations = this.getRegistrations(key, keys);
        if (registrations.size() > 1) {
            throw new CorrelationServiceException("CS_NO_SPRAY", new Object[0]);
        }
        Registration reg = null;
        if (registrations.size() > 0) {
            reg = (Registration)registrations.iterator().next();
            this.lockRootProcessInstance(ed, reg);
        }
        return reg;
    }

    private Collection getAllDefinedNonInstanceCreatingOperations(IStaticKey key) throws BPException {
        DefinitionService ds = this.getProcessService().getInstanceService().getDefinitionService();
        return ds.getNonInstanceCreatingOps(key);
    }

    private IResponseMessage mapResult(SentMessageData smd, IInternalEventDirector ed, boolean sync) throws BPException {
        if (sync && !smd.spray) {
            IResponseMessage mer = ed.getMessageEvent().createResponseMessage();
            ReturnMessageLocatorHolder rmlh = ed.getReturnMessageMetadata();
            Fault replyFault = null;
            if (rmlh.getFaultName() != null) {
                replyFault = new Fault();
                replyFault.setFaultString(rmlh.getFaultName());
                BPRuntimeException bpre = new BPRuntimeException(rmlh.getFaultName(), "");
                bpre.setNameSpace(rmlh.getFaultNS());
                replyFault.setFaultException(bpre);
                mer.setFault(replyFault);
            }
            Iterator it = rmlh.getLocators();
            InstanceService is = ed.getProcessService().getInstanceService();
            IPMIProcess ipmip = is.getInstance(rmlh.getRootProcessID(), rmlh.getRootProcessID());
            ContextResolver resolver = new ContextResolver(ipmip, rmlh, ed.getProcessService().getContextService(ipmip), ed.getProcessService().getScopeService(ipmip));
            try {
                SerializationContext sc = new SerializationContext(System.out);
                sc.printComment("Correlation Service Context:");
                sc.serialize(resolver.getContextService());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ScopePath saveSP = ipmip.getScopePath();
            ipmip.setScopePath(rmlh.getScopePath());
            while (it.hasNext()) {
                IPMDLocator loc = (IPMDLocator)it.next();
                String name = loc.getName();
                String[] name_split = name.split(":");
                Collection corrlSets = rmlh.getCorrlSets();
                if (corrlSets != null && corrlSets.contains(name_split[0])) continue;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Adding " + loc.getName() + " to return message");
                }
                IResolvedObject ro = null;
                ro = resolver.resolveBPContext(loc.getName());
                Object obj = ro.getValue();
                IInteraction interaction = null;
                if (obj instanceof IInteraction) {
                    interaction = (IInteraction)ro.getValue();
                } else if (obj instanceof String) {
                    interaction = InteractionFactory.newInstance().createXMLInteraction(((String)ro.getValue()).getBytes());
                }
                if (replyFault == null) {
                    mer.setPart(name_split[1], interaction);
                    continue;
                }
                BPRuntimeException bpre = (BPRuntimeException)replyFault.getFaultException();
                bpre.addPartMessage(name_split[1], interaction);
            }
            ipmip.setScopePath(saveSP);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("updatting instance service and removing lock for:" + ipmip.getRootKey());
            }
            ed.getProcessService().update(ipmip.getRootKey(), ed, ed);
            return mer;
        }
        Iterator it = ((AbstractList)smd.rootIds).iterator();
        while (it.hasNext()) {
            ed.getProcessService().update((String)it.next(), ed, ed);
        }
        return ed.getMessageEvent().createResponseMessage();
    }

    private String getCorrelationKeys(Collection operations) {
        String rtnVal = new String();
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            IPMDOperation op = (IPMDOperation)it.next();
            if (op.getCorrelation() == null) continue;
            Iterator it2 = op.getCorrelation().getCorrelationSets().iterator();
            while (it2.hasNext()) {
                IPMDCorrelationSet corrlset = (IPMDCorrelationSet)it2.next();
                Iterator it3 = corrlset.getPartQueries().iterator();
                while (it3.hasNext()) {
                    Invocation query;
                    PartQuery pq = (PartQuery)it3.next();
                    rtnVal = rtnVal + pq.getPartName();
                    if (pq.getQuery() != null && pq.getQuery() instanceof Invocation && (query = (Invocation)pq.getQuery()).getQuery() instanceof JaxenXPathSingleNodeQuery) {
                        JaxenXPathSingleNodeQuery jsnq = (JaxenXPathSingleNodeQuery)query.getQuery();
                        try {
                            rtnVal = rtnVal + ":";
                            rtnVal = rtnVal + jsnq.getXPathExpression();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    rtnVal = rtnVal + " ";
                }
            }
        }
        return rtnVal;
    }

    private String getCorrelationValues(IRequestMessageEvent me, Collection operations) {
        String rtnVal = new String();
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            IPMDOperation op = (IPMDOperation)it.next();
            if (op.getCorrelation() == null) continue;
            Iterator it2 = op.getCorrelation().getCorrelationSets().iterator();
            while (it2.hasNext()) {
                IPMDCorrelationSet corrlset = (IPMDCorrelationSet)it2.next();
                try {
                    Iterator it3 = corrlset.getPartQueries().iterator();
                    while (it3.hasNext()) {
                        IInvocation invocation;
                        String s;
                        PartQuery pq = (PartQuery)it3.next();
                        IInteraction part = me.getPart(pq.getPartName());
                        if (part == null || (s = (invocation = (IInvocation)pq.getQuery()) != null ? part.invoke(invocation).toString() : part.toString()) == null) continue;
                        rtnVal = rtnVal + s;
                        rtnVal = rtnVal + " ";
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, ResourceGetter.getString("ED_ED_EWM"), e);
                    return null;
                }
            }
        }
        return rtnVal;
    }

    private Collection computeKeys(IRequestMessageEvent me, Collection operations, boolean dups) {
        AbstractCollection keys = null;
        keys = dups ? new ArrayList() : new HashSet();
        Iterator it = operations.iterator();
        while (it.hasNext()) {
            IPMDOperation op = (IPMDOperation)it.next();
            if (op.getCorrelation() == null) {
                keys.add(null);
                continue;
            }
            StringBuffer buff = new StringBuffer("");
            Iterator it2 = op.getCorrelation().getCorrelationSets().iterator();
            while (it2.hasNext()) {
                IPMDCorrelationSet corrlset = (IPMDCorrelationSet)it2.next();
                buff.append(this.makeKeyValue(me, corrlset.getPartQueries()));
            }
            keys.add(buff.toString());
            buff = new StringBuffer("");
            boolean foundNonInstantiating = false;
            it2 = op.getCorrelation().getCorrelationSets().iterator();
            while (it2.hasNext()) {
                IPMDCorrelationSet corrlset = (IPMDCorrelationSet)it2.next();
                if (corrlset.isInstantiating()) continue;
                buff.append(this.makeKeyValue(me, corrlset.getPartQueries()));
                foundNonInstantiating = true;
            }
            if (!buff.toString().equals("")) {
                keys.add(buff.toString());
            }
            if (foundNonInstantiating) continue;
            keys.add(null);
        }
        return keys;
    }

    private String makeKeyValue(IRequestMessageEvent me, Collection keyMetaData) {
        StringBuffer buff = new StringBuffer();
        try {
            Iterator it = keyMetaData.iterator();
            String s = null;
            while (it.hasNext()) {
                IInvocation invocation;
                PartQuery pq = (PartQuery)it.next();
                IInteraction part = me.getPart(pq.getPartName());
                if (part == null || (s = (invocation = (IInvocation)pq.getQuery()) != null ? part.invoke(invocation).toString() : part.toString()) == null) continue;
                buff.append(s);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, ResourceGetter.getString("ED_ED_EWM"), e);
            return null;
        }
        return buff.toString();
    }

    private boolean isStatefull(Collection defOps) throws BPException {
        boolean ret = false;
        DefinitionService ds = this.getProcessService().getInstanceService().getDefinitionService();
        Iterator iter = defOps.iterator();
        while (iter.hasNext()) {
            IPMDOperation op = (IPMDOperation)iter.next();
            op.getRootDefId();
            IPMDRoot root = ds.getRootDefinition(new ProcessDefinitionKey(op.getRootDefId()));
            if (root.getIsStateless()) continue;
            ret = true;
            break;
        }
        return ret;
    }

    private void sentMessage(SentMessageData smd, String rootid) throws CorrelationServiceException {
        if (smd.messageSent && this.isBPELCompliant()) {
            CorrelationServiceException cse = new CorrelationServiceException("CS_NON_BPEL", null);
            cse.log(logger, Level.SEVERE);
            throw cse;
        }
        if (smd.messageSent) {
            smd.spray = true;
        }
        smd.rootIds.add(rootid);
        smd.messageSent = true;
    }

    private void lockRootProcessInstance(IInternalEventDirector ed, Registration reg) throws BPException {
        this.lock(ed, reg.getRootProcId());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SentMessageData {
        boolean spray = false;
        ArrayList rootIds = new ArrayList();
        boolean messageSent = false;

        SentMessageData() {
        }
    }
}

