/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.deployment.bpel;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import org.apache.ode.bpe.definition.service.DefinitionService;
import org.apache.ode.bpe.deployment.Deploy;
import org.apache.ode.bpe.deployment.bpel.BPELDefinitionKey;
import org.apache.ode.bpe.deployment.bpel.BPELParser;
import org.apache.ode.bpe.deployment.bpel.DeploymentException;
import org.apache.ode.bpe.lang.ResourceGetter;
import org.apache.ode.bpe.util.BPException;

public class BPELDeploy
implements Deploy {
    private static final int BUFFER = 2048;
    private static final Logger logger = Logger.getLogger((class$org$apache$ode$bpe$deployment$bpel$BPELDeploy == null ? (class$org$apache$ode$bpe$deployment$bpel$BPELDeploy = BPELDeploy.class$("org.apache.ode.bpe.deployment.bpel.BPELDeploy")) : class$org$apache$ode$bpe$deployment$bpel$BPELDeploy).getName());
    private static final Pattern bpelPattern = Pattern.compile(".*\\.bpel");
    private final HashMap bpelDoc = new HashMap();
    private final HashMap supportDoc = new HashMap();
    private DefinitionService ds;
    static /* synthetic */ Class class$org$apache$ode$bpe$deployment$bpel$BPELDeploy;

    public BPELDeploy(DefinitionService ds) {
        this.ds = ds;
    }

    public Collection deployJar(InputStream is, boolean validating, String schemaPath) throws BPException {
        String schemaFileName = schemaPath;
        ZipInputStream jis = null;
        FilterOutputStream dest = null;
        ByteArrayOutputStream baos = null;
        JarEntry entry = null;
        if (schemaFileName == null) {
            schemaFileName = this.ds.getBPEProperties().getDefinitionSchema();
        }
        try {
            jis = is instanceof BufferedInputStream ? new JarInputStream(is) : new JarInputStream(new BufferedInputStream(is));
            byte[] data = new byte[2048];
            while ((entry = ((JarInputStream)jis).getNextJarEntry()) != null) {
                int count;
                logger.log(Level.FINE, ResourceGetter.getFormatted("DEPLOY_EXTRACT", new Object[]{entry.getName()}));
                baos = new ByteArrayOutputStream();
                dest = new BufferedOutputStream(baos, 2048);
                while ((count = ((JarInputStream)jis).read(data, 0, 2048)) != -1) {
                    ((BufferedOutputStream)dest).write(data, 0, count);
                }
                dest.close();
                this.mapDocument(entry.getName(), baos.toByteArray());
                dest = null;
            }
        }
        catch (IOException e) {
            DeploymentException bpx = new DeploymentException("NATIVE_EXCEPTION", new Object[]{"IOException"}, e);
            bpx.log(logger, Level.SEVERE);
            throw bpx;
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        Iterator itr = this.bpelDoc.keySet().iterator();
        Vector<BPELDefinitionKey> ret = new Vector<BPELDefinitionKey>();
        while (itr.hasNext()) {
            String documentName = (String)itr.next();
            byte[] data = (byte[])this.bpelDoc.get(documentName);
            ret.add(BPELParser.parseBPEL(documentName, data, this.supportDoc, this.ds, validating, schemaFileName));
        }
        return ret;
    }

    private void mapDocument(String key, byte[] document) {
        Matcher m = bpelPattern.matcher(key);
        if (m.matches()) {
            this.bpelDoc.put(key.substring(0, key.lastIndexOf(".")).toLowerCase(), document);
        } else {
            this.supportDoc.put(key.toLowerCase(), document);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

