/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.event;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.ode.bpe.engine.IEvaluationContext;
import org.apache.ode.bpe.engine.IProcessCallBack;
import org.apache.ode.bpe.engine.ProcessInstance;
import org.apache.ode.bpe.engine.StateEnum;
import org.apache.ode.bpe.event.EventException;
import org.apache.ode.bpe.event.ProcessInstanceEvent;
import org.apache.ode.bpe.util.BPException;

public class StateEvent
extends ProcessInstanceEvent
implements Serializable {
    static final long serialVersionUID = -538982297121415925L;
    public static String PROCESS_STATE_NAME = "ProcessState";
    private StateEnum state;

    public StateEvent(String rootKey, String pKey, StateEnum state) {
        super(rootKey, pKey);
        this.state = state;
    }

    public StateEvent() {
        this.state = null;
    }

    public void init(Properties attributes) throws EventException {
        super.init(attributes);
        Object obj = ((Hashtable)attributes).get(PROCESS_STATE_NAME);
        if (!(obj instanceof StateEnum)) {
            throw new EventException("INVALID_PROCESS_STATE", new Object[]{obj});
        }
        this.state = (StateEnum)obj;
    }

    public void apply(ProcessInstance processInstance, IEvaluationContext ec, IProcessCallBack pcb) throws BPException {
        super.apply(processInstance, ec, pcb);
        processInstance.setState(this.state);
        if (this.state.equals(StateEnum.TERMINATED)) {
            processInstance.terminate(ec, pcb);
            ec.getProcessService().getInstanceService().getInstance(processInstance.getRootKey(), processInstance.getRootKey()).setMarkedForCleanUp(true);
        }
    }

    public Properties getAttributes() {
        Properties retVal = super.getAttributes();
        ((Hashtable)retVal).put(PROCESS_STATE_NAME, this.state);
        return retVal;
    }

    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }
}

