/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.operations;

import java.io.Serializable;
import java.util.List;
import org.apache.ode.bpe.interaction.IDocumentAccessible;
import org.apache.ode.bpe.interaction.InteractionException;
import org.apache.ode.bpe.interaction.operations.IOperation;
import org.apache.ode.bpe.interaction.query.IDocumentQuery;
import org.apache.ode.bpe.interaction.query.IQuery;
import org.w3c.dom.Document;

public abstract class DocumentOperation
implements IOperation,
Serializable {
    static final long serialVersionUID = 2889229303748016768L;
    private boolean m_nodeCreating = false;

    public DocumentOperation(boolean iIsNodeCreating) {
        this.setNodeCreating(iIsNodeCreating);
    }

    public Object execute(Object iTarget, IQuery query, Object iParameters, String xpath) throws Exception {
        IDocumentQuery documentQuery = (IDocumentQuery)query;
        if (!(iTarget instanceof IDocumentAccessible)) {
            throw new InteractionException("UNKNOWN_INVOCATION", null);
        }
        IDocumentAccessible documentAccessible = (IDocumentAccessible)iTarget;
        Document document = documentAccessible.getDocument();
        Object queryResult = documentQuery.runQuery(document);
        if ((queryResult == null || queryResult instanceof List && ((List)queryResult).isEmpty()) && this.getNodeCreating()) {
            queryResult = documentQuery.buildQueriedNode(document);
        }
        Object result = this.execute(queryResult, iParameters, xpath);
        return result;
    }

    public boolean getNodeCreating() {
        return this.m_nodeCreating;
    }

    public void setNodeCreating(boolean iIsNodeCreating) {
        this.m_nodeCreating = iIsNodeCreating;
    }

    protected abstract Object execute(Object var1, Object var2, String var3) throws Exception;

    public abstract /* synthetic */ boolean isMutator();
}

