/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpe.interaction.query;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.ode.bpe.interaction.operations.DOMUtil;
import org.apache.ode.bpe.interaction.query.CannotBuildNodeException;
import org.apache.ode.bpe.interaction.query.INodeBuilder;
import org.apache.ode.bpe.interaction.query.JaxenXPathSingleNodeQuery;
import org.apache.ode.bpe.interaction.query.NodeDescriptor;
import org.apache.ode.bpe.interaction.query.XPathParser;
import org.jaxen.FunctionContext;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.XPathFunctionContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JaxenNodeBuilder
implements INodeBuilder,
Serializable {
    static final long serialVersionUID = 9183764444392953826L;
    private XPathParser m_XPathParser;
    private LinkedList m_subQueries = new LinkedList();
    private SimpleNamespaceContext m_namespaceContext = null;

    public JaxenNodeBuilder() {
    }

    public JaxenNodeBuilder(HashMap iURIMap, String iExpression) throws JaxenException {
        this.m_namespaceContext = new SimpleNamespaceContext((Map)iURIMap);
        this.m_XPathParser = new XPathParser(iURIMap, iExpression);
        this.buildSubQueries();
    }

    private void buildSubQueries() throws JaxenException {
        this.m_subQueries.clear();
        Iterator iter = this.m_XPathParser.getNodeDescriptors().iterator();
        DOMXPath currentQuery = null;
        String currentQueryString = "";
        while (iter.hasNext()) {
            NodeDescriptor nodeDescriptor = (NodeDescriptor)iter.next();
            currentQueryString = currentQueryString + "/" + nodeDescriptor.getName();
            currentQuery = new DOMXPath(currentQueryString);
            currentQuery.setNamespaceContext((NamespaceContext)this.m_namespaceContext);
            currentQuery.setFunctionContext((FunctionContext)new XPathFunctionContext());
            if (currentQuery == null) continue;
            this.m_subQueries.addFirst(new Object[]{currentQuery, nodeDescriptor});
        }
    }

    public Node buildNode(Document iDocument) throws Exception {
        Iterator iter = this.m_subQueries.iterator();
        LinkedList<NodeDescriptor> nodesToBuild = new LinkedList<NodeDescriptor>();
        Node returnNode = null;
        while (iter.hasNext()) {
            Object[] nextPair = (Object[])iter.next();
            DOMXPath query = (DOMXPath)nextPair[0];
            NodeDescriptor descriptor = (NodeDescriptor)nextPair[1];
            Object resultObject = JaxenXPathSingleNodeQuery.runSingleNodeQuery(query, iDocument, query.getRootExpr().getText());
            if (resultObject == null || resultObject instanceof List && ((List)resultObject).isEmpty()) {
                if (!descriptor.canBuild() && !descriptor.getName().equals("*")) {
                    throw new CannotBuildNodeException();
                }
                nodesToBuild.addFirst(descriptor);
                continue;
            }
            returnNode = DOMUtil.buildNodes((Node)resultObject, nodesToBuild);
            break;
        }
        if (returnNode == null) {
            returnNode = DOMUtil.buildNodes(iDocument, nodesToBuild);
        }
        return returnNode;
    }
}

